/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.utils;

import io.ballerina.persist.BalException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JdbcDriverLoader
extends URLClassLoader {
    public JdbcDriverLoader(URL[] urls, Path driverPath) throws MalformedURLException, BalException {
        super(urls);
        List<Path> pathList = this.listFiles(driverPath);
        for (Path path : pathList) {
            this.addURL(new File(path.toString()).toURI().toURL());
        }
    }

    private List<Path> listFiles(Path path) throws BalException {
        ArrayList<Path> arrayList;
        block8: {
            Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
            try {
                List<Path> list = arrayList = walk != null ? walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()) : new ArrayList<Path>();
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BalException("failed to load JDBC driver : " + e.getMessage());
                }
            }
            walk.close();
        }
        return arrayList;
    }
}

