/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.utils;

import io.ballerina.persist.introspectiondto.SqlColumn;
import io.ballerina.persist.introspectiondto.SqlEnum;
import io.ballerina.persist.introspectiondto.SqlForeignKey;
import io.ballerina.persist.introspectiondto.SqlIndex;
import io.ballerina.persist.introspectiondto.SqlTable;
import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ScriptRunner {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String DEFAULT_DELIMITER = ";";
    private final Connection connection;

    public ScriptRunner(Connection connection) {
        this.connection = connection;
    }

    public void runScript(Reader reader) throws Exception {
        try {
            this.executeLineByLine(reader);
        }
        finally {
            this.rollbackConnection();
        }
    }

    public void runQuery(String query) throws SQLException {
        try {
            this.executeStatement(query);
        }
        finally {
            this.rollbackConnection();
        }
    }

    private void executeLineByLine(Reader reader) throws Exception {
        String line;
        StringBuilder command = new StringBuilder();
        BufferedReader lineReader = new BufferedReader(reader);
        while ((line = lineReader.readLine()) != null) {
            this.handleLine(command, line);
        }
        this.commitConnection();
        this.checkForMissingLineTerminator(command);
    }

    private void commitConnection() throws Exception {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (Throwable t) {
            throw new Exception("could not commit transaction. Message: " + t.getMessage(), t);
        }
    }

    private void rollbackConnection() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkForMissingLineTerminator(StringBuilder command) throws Exception {
        if (command != null && command.toString().trim().length() > 0) {
            throw new Exception("line missing end-of-line terminator (;) => " + String.valueOf(command));
        }
    }

    private void handleLine(StringBuilder command, String line) throws SQLException {
        String trimmedLine = line.trim();
        if (this.lineIsComment(trimmedLine)) {
            return;
        }
        if (this.commandReadyToExecute(trimmedLine)) {
            command.append(line, 0, line.lastIndexOf(DEFAULT_DELIMITER) + 1);
            command.append(LINE_SEPARATOR);
            this.executeStatement(command.toString());
            command.setLength(0);
        } else if (trimmedLine.length() > 0) {
            command.append(line);
            command.append(LINE_SEPARATOR);
        }
    }

    private boolean lineIsComment(String trimmedLine) {
        return trimmedLine.startsWith("//") || trimmedLine.startsWith("--");
    }

    private boolean commandReadyToExecute(String trimmedLine) {
        return trimmedLine.contains(DEFAULT_DELIMITER);
    }

    private void executeStatement(String command) throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            String sql = command;
            sql = sql.replace("\r\n", "\n");
            statement.execute(sql);
        }
    }

    /*
     * Exception decompiling
     */
    public List<SqlTable> getSQLTables(String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<SqlEnum> getSQLEnums(String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void readColumnsOfSQLTable(SqlTable table, String query) throws SQLException {
        try (Statement statement = this.connection.createStatement();
             ResultSet results = statement.executeQuery(query);){
            while (results.next()) {
                SqlColumn column = SqlColumn.newBuilder(results.getString("column_name")).setTableName(results.getString("table_name")).setDataType(results.getString("data_type")).setFullDataType(results.getString("full_data_type")).setCharacterMaximumLength(results.getString("character_maximum_length")).setNumericPrecision(results.getString("numeric_precision")).setNumericScale(results.getString("numeric_scale")).setColumnDefault(results.getString("column_default")).setIsNullable(results.getString("is_nullable")).setIsPrimaryKey(results.getString("column_key").equals("PRI")).setIsDbGenerated(results.getBoolean("dbgenerated")).setCheckConstraint(results.getString("check_constraint")).build();
                table.addColumn(column);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error while retrieving columns for table: " + e.getMessage());
        }
        finally {
            this.rollbackConnection();
        }
    }

    public List<SqlForeignKey> readForeignKeysOfSQLTable(SqlTable table, String query) throws SQLException {
        ArrayList<SqlForeignKey> sqlForeignKeys = new ArrayList<SqlForeignKey>();
        try {
            ArrayList<SqlForeignKey> arrayList;
            block20: {
                Statement statement = this.connection.createStatement();
                try {
                    try (ResultSet results = statement.executeQuery(query);){
                        while (results.next()) {
                            String constraintName = results.getString("constraint_name");
                            SqlForeignKey existingForeignKey = table.getSqlForeignKeys().stream().filter(fKey -> fKey.getConstraintName().equals(constraintName)).findFirst().orElse(null);
                            if (existingForeignKey == null) {
                                SqlForeignKey foreignKey = SqlForeignKey.Builder.newBuilder(results.getString("constraint_name")).setTableName(results.getString("table_name")).addColumnName(results.getString("column_name")).setReferencedTableName(results.getString("referenced_table_name")).addReferencedColumnName(results.getString("referenced_column_name")).setUpdateRule(results.getString("update_rule")).setDeleteRule(results.getString("delete_rule")).build();
                                table.addForeignKey(foreignKey);
                                sqlForeignKeys.add(foreignKey);
                                continue;
                            }
                            existingForeignKey.addColumnName(results.getString("column_name"));
                            existingForeignKey.addReferencedColumnName(results.getString("referenced_column_name"));
                        }
                    }
                    arrayList = sqlForeignKeys;
                    if (statement == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new SQLException("Error while retrieving foreign keys for table: " + e.getMessage());
                    }
                }
                statement.close();
            }
            return arrayList;
        }
        finally {
            this.rollbackConnection();
        }
    }

    public void readIndexesOfSQLTable(SqlTable table, String query) throws SQLException {
        try (Statement statement = this.connection.createStatement();
             ResultSet results = statement.executeQuery(query);){
            while (results.next()) {
                String indexName = results.getString("index_name");
                SqlIndex existingIndex = table.getIndexes().stream().filter(index -> index.getIndexName().equals(indexName)).findFirst().orElse(null);
                if (existingIndex == null) {
                    table.addIndex(SqlIndex.Builder.newBuilder(results.getString("index_name")).setTableName(results.getString("table_name")).addColumnName(results.getString("column_name")).setUnique(results.getBoolean("is_unique")).build());
                    continue;
                }
                existingIndex.addColumnName(results.getString("column_name"));
            }
        }
        catch (SQLException e) {
            throw new SQLException("error while retrieving indexes for table: " + e.getMessage());
        }
        finally {
            this.rollbackConnection();
        }
    }
}

