/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.internal.ExceptionHelper;
import org.eclipse.paho.mqttv5.client.internal.NetworkModule;
import org.eclipse.paho.mqttv5.client.internal.TCPNetworkModule;
import org.eclipse.paho.mqttv5.client.spi.NetworkModuleFactory;
import org.eclipse.paho.mqttv5.common.MqttException;

public class TCPNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("tcp")));
    }

    @Override
    public void validateURI(URI brokerUri) throws IllegalArgumentException {
        String path = brokerUri.getPath();
        if (path != null && !path.isEmpty()) {
            throw new IllegalArgumentException("URI path must be empty \"" + brokerUri.toString() + "\"");
        }
    }

    @Override
    public NetworkModule createNetworkModule(URI brokerUri, MqttConnectionOptions options, String clientId) throws MqttException {
        String path;
        String host = brokerUri.getHost();
        int port = brokerUri.getPort();
        if (port == -1) {
            port = 1883;
        }
        if ((path = brokerUri.getPath()) != null && !path.isEmpty()) {
            throw new IllegalArgumentException(brokerUri.toString());
        }
        SocketFactory factory = options.getSocketFactory();
        if (factory == null) {
            factory = SocketFactory.getDefault();
        } else if (factory instanceof SSLSocketFactory) {
            throw ExceptionHelper.createMqttException(32105);
        }
        TCPNetworkModule networkModule = new TCPNetworkModule(factory, host, port, clientId);
        networkModule.setConnectTimeout(options.getConnectionTimeout());
        return networkModule;
    }
}

