/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.linter.impl.codeactions;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.List;

public abstract class LinterCodeAction
implements CodeAction {
    static NonTerminalNode getNodeFromDiagnostics(CodeActionContext context) {
        LineRange lineRange = context.diagnostic().location().lineRange();
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int endOffset = textDocument.textPositionFrom(lineRange.endLine());
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(endOffset - start)), true);
    }

    static DocumentEdit getDocumentEdit(CodeActionExecutionContext context, LineRange lineRange, String updatedText) {
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int endOffset = textDocument.textPositionFrom(lineRange.endLine());
        TextEdit edit = TextEdit.from((TextRange)TextRange.from((int)start, (int)(endOffset - start)), (String)updatedText);
        TextDocumentChange textDocumentChange = TextDocumentChange.from((TextEdit[])List.of(edit).toArray(new TextEdit[0]));
        TextDocument modified = syntaxTree.textDocument().apply(textDocumentChange);
        return new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modified));
    }
}

