/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.tcp.TcpListener;
import io.ballerina.stdlib.tcp.TcpService;
import io.ballerina.stdlib.tcp.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher {
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);

    private static void invokeOnBytes(TcpService tcpService, ByteBuf buffer, Channel channel, Type[] parameterTypes) {
        try {
            Object[] params = Dispatcher.getOnBytesSignature(buffer, channel, tcpService, parameterTypes);
            BObject connService = tcpService.getConnectionService();
            Dispatcher.invokeAsyncCall(connService, "onBytes", tcpService, channel, false, params);
        }
        catch (BError e) {
            Dispatcher.invokeOnError(tcpService, e.getMessage());
        }
    }

    public static void invokeOnError(TcpService tcpService, String message) {
        if (tcpService.getConnectionService() == null) {
            return;
        }
        try {
            ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)tcpService.getConnectionService()));
            MethodType methodType = Arrays.stream(objectType.getMethods()).filter(m -> m.getName().equals("onError")).findFirst().orElse(null);
            if (methodType != null) {
                Object[] params = Dispatcher.getOnErrorSignature(message);
                BObject connService = tcpService.getConnectionService();
                Dispatcher.invokeAsyncCall(connService, "onError", tcpService, null, false, params);
            }
        }
        catch (Throwable t) {
            log.error("Error while executing onError function", t);
        }
    }

    private static Object[] getOnBytesSignature(ByteBuf buffer, Channel channel, TcpService tcpService, Type[] parameterTypes) {
        byte[] byteContent = new byte[buffer.readableBytes()];
        buffer.readBytes(byteContent);
        Object[] bValues = new Object[parameterTypes.length];
        int index = 0;
        block4: for (Type param : parameterTypes) {
            int paramTag = param.getTag();
            switch (paramTag) {
                case 34: {
                    bValues[index++] = ValueCreator.createReadonlyArrayValue((byte[])byteContent);
                    continue block4;
                }
                case 47: {
                    bValues[index++] = Dispatcher.createClient(channel, tcpService);
                    continue block4;
                }
            }
        }
        return bValues;
    }

    private static Object[] getOnErrorSignature(String message) {
        return new Object[]{Utils.createTcpError(message)};
    }

    private static BObject createClient(Channel channel, TcpService tcpService) {
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        InetSocketAddress localAddress = (InetSocketAddress)channel.localAddress();
        BObject caller = ValueCreator.createObjectValue((Module)Utils.getTcpPackage(), (String)"Caller", (Object[])new Object[]{StringUtils.fromString((String)remoteAddress.getHostName()), remoteAddress.getPort(), StringUtils.fromString((String)localAddress.getHostName()), localAddress.getPort(), StringUtils.fromString((String)channel.id().asLongText())});
        caller.addNativeData("channel", (Object)channel);
        caller.addNativeData("Service", (Object)tcpService);
        caller.addNativeData("id", (Object)channel.id().asLongText());
        return caller;
    }

    public static void invokeRead(TcpService tcpService, ByteBuf buffer, Channel channel) {
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)tcpService.getConnectionService()));
        for (MethodType method : objectType.getMethods()) {
            if (!method.getName().equals("onBytes")) continue;
            Parameter[] parameters = method.getType().getParameters();
            Type[] parameterTypes = new Type[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameterTypes[i] = parameters[i].type;
            }
            Dispatcher.invokeOnBytes(tcpService, buffer, channel, parameterTypes);
        }
    }

    public static void invokeOnConnect(TcpService tcpService, Channel channel) {
        try {
            Object[] params = Dispatcher.getOnConnectSignature(channel, tcpService);
            BObject balService = tcpService.getService();
            Dispatcher.invokeAsyncCall(balService, "onConnect", tcpService, channel, true, params);
        }
        catch (BError e) {
            Dispatcher.invokeOnError(tcpService, e.getMessage());
        }
    }

    private static void invokeAsyncCall(BObject balService, String methodName, TcpService tcpService, Channel channel, boolean isOnConnectInvoked, Object[] params) {
        Thread.startVirtualThread(() -> {
            try {
                Object result = tcpService.getRuntime().callMethod(balService, methodName, new StrandMetadata(Dispatcher.isIsolated(balService, methodName), null), params);
                Dispatcher.handleResult(result, channel, tcpService, isOnConnectInvoked);
            }
            catch (BError error) {
                Dispatcher.handleError(error);
            }
            catch (Throwable throwable) {
                Dispatcher.handleError(ErrorCreator.createError((Throwable)throwable));
            }
        });
    }

    private static void handleResult(Object result, Channel channel, TcpService tcpService, boolean isOnConnectInvoked) {
        if (result instanceof BArray) {
            byte[] byteContent = ((BArray)result).getBytes();
            TcpListener.send(byteContent, channel, tcpService);
        } else if (isOnConnectInvoked) {
            tcpService.setConnectionService((BObject)result);
            TcpListener.resumeRead(channel);
        } else if (result instanceof BError) {
            ((BError)((Object)result)).printStackTrace();
        }
        log.debug("Method successfully dispatched.");
    }

    private static void handleError(BError bError) {
        bError.printStackTrace();
    }

    private static Object[] getOnConnectSignature(Channel channel, TcpService tcpService) {
        BObject caller = Dispatcher.createClient(channel, tcpService);
        return new Object[]{caller};
    }

    public static void invokeOnClose(TcpService tcpService) {
        if (tcpService.getConnectionService() == null) {
            return;
        }
        try {
            ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)tcpService.getConnectionService()));
            MethodType methodType = Arrays.stream(objectType.getMethods()).filter(m -> m.getName().equals("onClose")).findFirst().orElse(null);
            if (methodType != null) {
                Object[] params = new Object[]{};
                BObject balService = tcpService.getConnectionService();
                Dispatcher.invokeAsyncCall(balService, "onClose", tcpService, null, false, params);
            }
        }
        catch (BError e) {
            Dispatcher.invokeOnError(tcpService, e.getMessage());
        }
    }

    private static boolean isIsolated(BObject serviceObj, String remoteMethod) {
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)serviceObj));
        return objectType.isIsolated() && objectType.isIsolated(remoteMethod);
    }

    private Dispatcher() {
    }
}

