/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.stdlib.tcp.TcpClientHandler;
import io.ballerina.stdlib.tcp.Utils;
import io.ballerina.stdlib.tcp.nativeclient.Client;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHandshakeClientEventHandler
extends ChannelInboundHandlerAdapter {
    private TcpClientHandler tcpClientHandler;
    private CompletableFuture<Object> balClientInitCallback;
    private static final Logger log = LoggerFactory.getLogger(Client.class);

    public SslHandshakeClientEventHandler(TcpClientHandler handler, CompletableFuture<Object> callback) {
        this.tcpClientHandler = handler;
        this.balClientInitCallback = callback;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof SslHandshakeCompletionEvent) {
            if (((SslHandshakeCompletionEvent)event).isSuccess()) {
                ctx.pipeline().addLast("flowControlHandler", (ChannelHandler)new FlowControlHandler());
                ctx.pipeline().addLast("clientHandler", (ChannelHandler)this.tcpClientHandler);
                ctx.channel().config().setAutoRead(false);
                this.balClientInitCallback.complete(null);
                ctx.pipeline().remove((ChannelHandler)this);
            } else {
                this.balClientInitCallback.complete(Utils.createTcpError(((SslHandshakeCompletionEvent)event).cause().getMessage()));
                this.balClientInitCallback = null;
                ctx.close();
            }
        } else if (!(event instanceof SslCloseCompletionEvent)) {
            log.warn("Unexpected user event triggered");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("Error while SSL handshake: " + cause.getMessage());
        if (cause instanceof DecoderException && this.balClientInitCallback != null) {
            this.balClientInitCallback.complete(Utils.createTcpError(cause.getMessage()));
            ctx.close();
        }
    }
}

