/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.stdlib.tcp.Utils;
import io.ballerina.stdlib.tcp.WriteFlowController;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpClientHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private CompletableFuture<Object> callback;
    private AtomicBoolean writeFutureCompleted = new AtomicBoolean(false);
    private boolean isCloseTriggered = false;
    private LinkedList<WriteFlowController> writeFlowControllers = new LinkedList();

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.isCloseTriggered && this.callback != null) {
            this.callback.complete(Utils.createTcpError("Connection closed by the server."));
        }
        ctx.channel().close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ctx.channel().pipeline().remove("readTimeoutHandler");
        if (this.callback != null) {
            this.callback.complete(Utils.returnReadOnlyBytes(msg));
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof IdleStateEvent) {
            IdleStateEvent evt = (IdleStateEvent)event;
            if (evt.state() == IdleState.READER_IDLE) {
                ctx.channel().pipeline().remove("readTimeoutHandler");
                if (this.callback != null) {
                    this.callback.complete(Utils.createTcpError("Read timed out"));
                }
            } else if (evt.state() == IdleState.WRITER_IDLE) {
                ctx.channel().pipeline().remove("writeTimeoutHandler");
                if (this.callback != null && !this.writeFutureCompleted.get()) {
                    this.writeFutureCompleted.set(true);
                    this.callback.complete(Utils.createTcpError("Write timed out"));
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().pipeline().remove("readTimeoutHandler");
        if (this.callback != null) {
            this.callback.complete(Utils.createTcpError(cause.getMessage()));
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        while (this.writeFlowControllers.size() > 0) {
            WriteFlowController writeFlowController;
            if (!ctx.channel().isWritable() || (writeFlowController = this.writeFlowControllers.getFirst()) == null) continue;
            writeFlowController.writeData(ctx.channel(), this.writeFlowControllers);
        }
    }

    public void setCallback(CompletableFuture<Object> callback) {
        this.callback = callback;
    }

    public void setWriteFutureCompleted(AtomicBoolean writeFutureCompleted) {
        this.writeFutureCompleted = writeFutureCompleted;
    }

    public void setIsCloseTriggered() {
        this.isCloseTriggered = true;
    }

    public void addWriteFlowControl(WriteFlowController writeFlowController) {
        this.writeFlowControllers.addLast(writeFlowController);
    }

    public LinkedList<WriteFlowController> getWriteFlowControllers() {
        return this.writeFlowControllers;
    }
}

