/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.stdlib.tcp.Dispatcher;
import io.ballerina.stdlib.tcp.TcpListener;
import io.ballerina.stdlib.tcp.TcpService;
import io.ballerina.stdlib.tcp.WriteFlowController;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.LinkedList;

public class TcpListenerHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final TcpService tcpService;
    private LinkedList<WriteFlowController> writeFlowControllers = new LinkedList();

    public TcpListenerHandler(TcpService tcpService) {
        this.tcpService = tcpService;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().close();
        Dispatcher.invokeOnClose(this.tcpService);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        Dispatcher.invokeRead(this.tcpService, msg, ctx.channel());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        TcpListener.pauseRead(ctx.channel());
        Dispatcher.invokeOnConnect(this.tcpService, ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Dispatcher.invokeOnError(this.tcpService, cause.getMessage());
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        while (this.writeFlowControllers.size() > 0) {
            WriteFlowController writeFlowController;
            if (!ctx.channel().isWritable() || (writeFlowController = this.writeFlowControllers.getFirst()) == null) continue;
            writeFlowController.writeData(ctx.channel(), this.writeFlowControllers);
        }
    }

    public void addWriteFlowControl(WriteFlowController writeFlowController) {
        this.writeFlowControllers.addLast(writeFlowController);
    }

    public LinkedList<WriteFlowController> getWriteFlowControllers() {
        return this.writeFlowControllers;
    }
}

