/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.tcp.Constants;
import io.ballerina.stdlib.tcp.SSLConfig;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.concurrent.CompletableFuture;

public class Utils {
    private static Module tcpModule = null;

    private Utils() {
    }

    public static BError createTcpError(String errMsg) {
        return ErrorCreator.createError((Module)Utils.getTcpPackage(), (String)Constants.ErrorType.Error.errorType(), (BString)StringUtils.fromString((String)errMsg), null, null);
    }

    public static BArray returnReadOnlyBytes(ByteBuf buf) {
        byte[] byteContent = new byte[buf.readableBytes()];
        buf.readBytes(byteContent);
        return ValueCreator.createReadonlyArrayValue((byte[])byteContent);
    }

    public static SSLConfig setSslConfig(BMap<BString, Object> secureSocket, SSLConfig sslConfig, boolean isListener) throws Exception {
        BArray ciphers;
        if (isListener) {
            BMap<BString, Object> key = Utils.getBMapValueIfPresent(secureSocket, Constants.SECURESOCKET_CONFIG_KEY);
            Utils.evaluateKeyField(key, sslConfig);
        } else {
            Object cert = secureSocket.get((Object)Constants.SECURESOCKET_CONFIG_CERT);
            Utils.evaluateCertField(cert, sslConfig);
        }
        BMap<BString, Object> protocol = Utils.getBMapValueIfPresent(secureSocket, Constants.SECURESOCKET_CONFIG_PROTOCOL);
        if (protocol != null) {
            Utils.evaluateProtocolField(protocol, sslConfig);
        }
        BArray bArray = ciphers = secureSocket.containsKey((Object)Constants.SECURESOCKET_CONFIG_CIPHERS) ? secureSocket.getArrayValue(Constants.SECURESOCKET_CONFIG_CIPHERS) : null;
        if (ciphers != null) {
            Utils.evaluateCiphersField(ciphers, sslConfig);
        }
        sslConfig.setTLSStoreType("PKCS12");
        Utils.evaluateCommonFields(secureSocket, sslConfig);
        return sslConfig;
    }

    private static BMap<BString, Object> getBMapValueIfPresent(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? map.getMapValue(key) : null;
    }

    private static void evaluateKeyField(BMap<BString, Object> key, SSLConfig sslConfig) throws Exception {
        if (key.containsKey((Object)Constants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH)) {
            String keyStoreFile = key.getStringValue(Constants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH).getValue();
            if (keyStoreFile.isBlank()) {
                throw new Exception("KeyStore file location must be provided for secure connection");
            }
            String keyStorePassword = key.getStringValue(Constants.SECURESOCKET_CONFIG_KEYSTORE_PASSWORD).getValue();
            if (keyStorePassword.isBlank()) {
                throw new Exception("KeyStore password must be provided for secure connection");
            }
            sslConfig.setKeyStore(new File(keyStoreFile));
            sslConfig.setKeyStorePass(keyStorePassword);
        } else {
            BString keyPassword;
            String certFile = key.getStringValue(Constants.SECURESOCKET_CONFIG_CERTKEY_CERT_FILE).getValue();
            String keyFile = key.getStringValue(Constants.SECURESOCKET_CONFIG_CERTKEY_KEY_FILE).getValue();
            BString bString = keyPassword = key.containsKey((Object)Constants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) ? key.getStringValue(Constants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) : null;
            if (certFile.isBlank()) {
                throw new Error("Certificate file location must be provided for secure connection");
            }
            if (keyFile.isBlank()) {
                throw new Error("Private key file location must be provided for secure connection");
            }
            sslConfig.setServerCertificates(new File(certFile));
            sslConfig.setServerKeyFile(new File(keyFile));
            if (keyPassword != null && !keyPassword.getValue().isBlank()) {
                sslConfig.setServerKeyPassword(keyPassword.getValue());
            }
        }
    }

    private static void evaluateCertField(Object cert, SSLConfig sslConfig) throws Exception {
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            String trustStoreFile = trustStore.getStringValue(Constants.SECURESOCKET_CONFIG_TRUSTSTORE_FILE_PATH).getValue();
            String trustStorePassword = trustStore.getStringValue(Constants.SECURESOCKET_CONFIG_TRUSTSTORE_PASSWORD).getValue();
            if (trustStoreFile.isBlank()) {
                throw new Exception("TrustStore file location must be provided for secure connection");
            }
            if (trustStorePassword.isBlank()) {
                throw new Exception("TrustStore password must be provided for secure connection");
            }
            sslConfig.setTrustStore(new File(trustStoreFile));
            sslConfig.setTrustStorePass(trustStorePassword);
        } else {
            String certFile = ((BString)cert).getValue();
            if (certFile.isBlank()) {
                throw new Exception("Certificate file location must be provided for secure connection");
            }
            sslConfig.setClientTrustCertificates(new File(certFile));
        }
    }

    private static void evaluateProtocolField(BMap<BString, Object> protocol, SSLConfig sslConfig) {
        String sslProtocol;
        String[] sslEnabledProtocolsValueList = protocol.getArrayValue(Constants.SECURESOCKET_CONFIG_PROTOCOL_VERSIONS).getStringArray();
        if (sslEnabledProtocolsValueList.length > 0) {
            sslConfig.setEnableProtocols(sslEnabledProtocolsValueList);
        }
        if (!(sslProtocol = protocol.getStringValue(Constants.SECURESOCKET_CONFIG_PROTOCOL_NAME).getValue()).isBlank()) {
            sslConfig.setSSLProtocol(sslProtocol);
        }
    }

    private static void evaluateCiphersField(BArray ciphers, SSLConfig sslConfig) {
        String[] ciphersArray = ciphers.getStringArray();
        if (ciphersArray.length > 0) {
            sslConfig.setCipherSuites(ciphersArray);
        }
    }

    private static void evaluateCommonFields(BMap<BString, Object> secureSocket, SSLConfig sslConfig) {
        sslConfig.setSessionTimeOut((int)Utils.getLongValueOrDefault(secureSocket, Constants.SECURESOCKET_CONFIG_SESSION_TIMEOUT));
        sslConfig.setHandshakeTimeOut(Utils.getLongValueOrDefault(secureSocket, Constants.SECURESOCKET_CONFIG_HANDSHAKE_TIMEOUT));
    }

    public static long getLongValueOrDefault(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? ((BDecimal)map.get((Object)key)).intValue() : 0L;
    }

    public static Module getTcpPackage() {
        return Utils.getModule();
    }

    public static void setModule(Environment env) {
        tcpModule = env.getCurrentModule();
    }

    public static Module getModule() {
        return tcpModule;
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable t) {
            return ErrorCreator.createError((Throwable)t);
        }
    }
}

