/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.stdlib.tcp.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class WriteFlowController {
    protected ByteBuf sendBuffer;
    private CompletableFuture<Object> balWriteCallback;
    private AtomicBoolean futureCompleted;

    WriteFlowController(ByteBuf buffer, CompletableFuture<Object> callback, AtomicBoolean futureCompleted) {
        this.balWriteCallback = callback;
        this.sendBuffer = buffer;
        this.futureCompleted = futureCompleted;
    }

    public WriteFlowController(ByteBuf buffer) {
        this.sendBuffer = buffer;
    }

    public synchronized void writeData(Channel channel, LinkedList<WriteFlowController> writeFlowControllers) {
        channel.writeAndFlush((Object)this.sendBuffer).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (channel.pipeline().get("writeTimeoutHandler") != null) {
                channel.pipeline().remove("writeTimeoutHandler");
            }
            this.completeCallback((ChannelFuture)future);
        }));
        writeFlowControllers.remove(this);
    }

    private void completeCallback(ChannelFuture future) {
        if (future.isSuccess()) {
            if (!this.futureCompleted.get()) {
                this.futureCompleted.set(true);
                this.balWriteCallback.complete(null);
            }
        } else if (!this.futureCompleted.get()) {
            this.futureCompleted.set(true);
            this.balWriteCallback.complete(Utils.createTcpError("Failed to write data: " + future.cause().getMessage()));
        }
    }
}

