/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.nativeclient;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.tcp.Constants;
import io.ballerina.stdlib.tcp.TcpClient;
import io.ballerina.stdlib.tcp.TcpFactory;
import io.ballerina.stdlib.tcp.Utils;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);

    private Client() {
    }

    public static Object externInit(Environment env, BObject client, BString remoteHost, int remotePort, BMap<BString, Object> config) {
        CompletableFuture balFuture = new CompletableFuture();
        return env.yieldAndRun(() -> {
            BString host = config.getStringValue(StringUtils.fromString((String)"localHost"));
            InetSocketAddress remoteAddress = new InetSocketAddress(remoteHost.getValue(), remotePort);
            InetSocketAddress localAddress = host == null ? new InetSocketAddress(0) : new InetSocketAddress(host.getValue(), 0);
            double timeout = ((BDecimal)config.get((Object)StringUtils.fromString((String)"timeout"))).floatValue();
            client.addNativeData("timeout", (Object)timeout);
            double writeTimeout = ((BDecimal)config.get((Object)StringUtils.fromString((String)"writeTimeout"))).floatValue();
            client.addNativeData("writeTimeout", (Object)writeTimeout);
            BMap secureSocket = config.getMapValue(Constants.SECURE_SOCKET);
            TcpClient tcpClient = TcpFactory.getInstance().createTcpClient(localAddress, remoteAddress, balFuture, (BMap<BString, Object>)secureSocket);
            client.addNativeData("Client", (Object)tcpClient);
            return Utils.getResult(balFuture);
        });
    }

    public static Object externReadBytes(Environment env, BObject client) {
        CompletableFuture balFuture = new CompletableFuture();
        return env.yieldAndRun(() -> {
            double readTimeOut = (Double)client.getNativeData("timeout");
            TcpClient tcpClient = (TcpClient)client.getNativeData("Client");
            tcpClient.readData(readTimeOut, balFuture);
            return Utils.getResult(balFuture);
        });
    }

    public static Object externWriteBytes(Environment env, BObject client, BArray content) {
        CompletableFuture balFuture = new CompletableFuture();
        return env.yieldAndRun(() -> {
            double writeTimeOut = (Double)client.getNativeData("writeTimeout");
            byte[] byteContent = content.getBytes();
            TcpClient tcpClient = (TcpClient)client.getNativeData("Client");
            tcpClient.writeData(byteContent, balFuture, writeTimeOut);
            return Utils.getResult(balFuture);
        });
    }

    public static Object externClose(Environment env, BObject client) {
        CompletableFuture balFuture = new CompletableFuture();
        return env.yieldAndRun(() -> {
            TcpClient tcpClient = (TcpClient)client.getNativeData("Client");
            tcpClient.close(balFuture);
            return Utils.getResult(balFuture);
        });
    }
}

