/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.nativelistener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.tcp.Dispatcher;
import io.ballerina.stdlib.tcp.TcpListener;
import io.ballerina.stdlib.tcp.TcpService;
import io.ballerina.stdlib.tcp.Utils;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;

public class Caller {
    public static Object externWriteBytes(Environment env, BObject caller, BArray data) {
        CompletableFuture callback = new CompletableFuture();
        return env.yieldAndRun(() -> {
            byte[] byteContent = data.getBytes();
            Channel channel = (Channel)caller.getNativeData("channel");
            TcpService tcpService = (TcpService)caller.getNativeData("Service");
            TcpListener.send(byteContent, channel, callback, tcpService);
            return Utils.getResult(callback);
        });
    }

    public static Object externClose(Environment env, BObject caller) {
        CompletableFuture callback = new CompletableFuture();
        return env.yieldAndRun(() -> {
            Channel channel = (Channel)caller.getNativeData("channel");
            TcpService tcpService = (TcpService)caller.getNativeData("Service");
            tcpService.setIsCallerClosed(true);
            try {
                TcpListener.close(channel, callback);
                Dispatcher.invokeOnClose(tcpService);
            }
            catch (Exception e) {
                callback.complete(Utils.createTcpError(e.getMessage()));
            }
            return Utils.getResult(callback);
        });
    }

    private Caller() {
    }
}

