/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.sequencemodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.sequencemodelgenerator.core.ParticipantManager;
import io.ballerina.sequencemodelgenerator.core.model.Expression;
import io.ballerina.sequencemodelgenerator.core.model.Interaction;
import io.ballerina.sequencemodelgenerator.core.model.SequenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;

public class ParticipantBodyAnalyzer
extends NodeVisitor {
    private final List<SequenceNode> sequenceNodes;
    private final SemanticModel semanticModel;
    private final Stack<SequenceNode.Builder> nodeBuilderStack;
    private SequenceNode.Builder nodeBuilder;
    private Node variableNode;

    public ParticipantBodyAnalyzer(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        this.sequenceNodes = new ArrayList<SequenceNode>();
        this.nodeBuilderStack = new Stack();
        this.nodeBuilder = new SequenceNode.Builder(semanticModel);
    }

    public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        String targetId = ParticipantManager.getInstance().getParticipantId((Node)remoteMethodCallActionNode.expression());
        this.nodeBuilder = new Interaction.Builder(this.semanticModel).interactionType(Interaction.InteractionType.ENDPOINT_CALL).targetId(targetId).location((Node)remoteMethodCallActionNode);
        this.nodeBuilder.property("params", this.getParamList((SeparatedNodeList<FunctionArgumentNode>)remoteMethodCallActionNode.arguments())).property("name", Expression.Factory.createStringType((Node)remoteMethodCallActionNode.methodName())).property("expr", (Node)remoteMethodCallActionNode.expression()).property("value", Expression.Factory.create(this.semanticModel, (Node)remoteMethodCallActionNode, this.variableNode));
        this.appendNode();
    }

    public void visit(ClientResourceAccessActionNode resourceAccessActionNode) {
        String targetId = ParticipantManager.getInstance().getParticipantId((Node)resourceAccessActionNode.expression());
        this.nodeBuilder = new Interaction.Builder(this.semanticModel).interactionType(Interaction.InteractionType.ENDPOINT_CALL).targetId(targetId).location((Node)resourceAccessActionNode);
        resourceAccessActionNode.arguments().ifPresent(arguments -> this.nodeBuilder.property("params", this.getParamList((SeparatedNodeList<FunctionArgumentNode>)arguments.arguments())));
        resourceAccessActionNode.methodName().ifPresent(name -> this.nodeBuilder.property("name", Expression.Factory.createStringType((Node)name)));
        SeparatedNodeList nodes = resourceAccessActionNode.resourceAccessPath();
        String resourcePath = nodes.stream().map(Node::toSourceCode).collect(Collectors.joining("/"));
        this.nodeBuilder.property("resourcePath", resourcePath);
        this.nodeBuilder.property("expr", (Node)resourceAccessActionNode.expression()).property("value", Expression.Factory.create(this.semanticModel, (Node)resourceAccessActionNode, this.variableNode));
        this.appendNode();
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        this.variableNode = variableDeclarationNode.typedBindingPattern().bindingPattern();
        variableDeclarationNode.initializer().ifPresent(expressionNode -> expressionNode.accept((NodeVisitor)this));
        this.variableNode = null;
    }

    public void visit(AssignmentStatementNode assignmentStatementNode) {
        this.variableNode = assignmentStatementNode.varRef();
        super.visit(assignmentStatementNode);
        this.variableNode = null;
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        NameReferenceNode functionName = functionCallExpressionNode.functionName();
        String targetId = ParticipantManager.getInstance().getParticipantId((Node)functionName);
        this.nodeBuilder = new Interaction.Builder(this.semanticModel).interactionType(Interaction.InteractionType.FUNCTION_CALL).targetId(targetId).location((Node)functionCallExpressionNode);
        this.nodeBuilder.property("params", this.getParamList((SeparatedNodeList<FunctionArgumentNode>)functionCallExpressionNode.arguments())).property("name", Expression.Factory.createStringType((Node)functionName));
        if (this.variableNode != null) {
            this.nodeBuilder.property("value", Expression.Factory.create(this.semanticModel, (Node)functionCallExpressionNode, this.variableNode));
        }
        this.appendNode();
    }

    private List<Expression> getParamList(SeparatedNodeList<FunctionArgumentNode> arguments) {
        return arguments.stream().map(argument -> Expression.Factory.create(this.semanticModel, (Node)argument)).toList();
    }

    public void visit(ReturnStatementNode returnStatementNode) {
        this.handleReturnAction((Node)returnStatementNode, returnStatementNode.expression().orElse(null));
    }

    public void visit(ExpressionFunctionBodyNode expressionFunctionBodyNode) {
        ExpressionNode expression = expressionFunctionBodyNode.expression();
        this.handleReturnAction((Node)expression, expression);
    }

    private void handleReturnAction(Node locationNode, ExpressionNode expression) {
        this.nodeBuilder.kind(SequenceNode.NodeKind.RETURN).location(locationNode);
        if (expression != null && expression.kind() != SyntaxKind.NIL_LITERAL) {
            this.nodeBuilder.property("value", Expression.Factory.createType(this.semanticModel, (Node)expression, true));
        }
        this.appendNode();
    }

    public void visit(IfElseStatementNode ifElseStatementNode) {
        this.nodeBuilder.kind(SequenceNode.NodeKind.IF).location((Node)ifElseStatementNode).property("condition", (Node)ifElseStatementNode.condition());
        ArrayList<SequenceNode> thenBlockNodes = new ArrayList<SequenceNode>();
        this.startBranch();
        for (StatementNode statement : ifElseStatementNode.ifBody().statements()) {
            statement.accept((NodeVisitor)this);
            this.addNode(thenBlockNodes, (Node)statement);
        }
        this.endBranch();
        this.nodeBuilder.branch("Then", thenBlockNodes);
        Optional elseBody = ifElseStatementNode.elseBody();
        if (elseBody.isPresent()) {
            this.startBranch();
            List<SequenceNode> elseNodes = this.analyzeElseBody((Node)elseBody.get());
            this.endBranch();
            this.nodeBuilder.branch("Else", elseNodes);
        }
        this.appendNode();
    }

    private List<SequenceNode> analyzeElseBody(Node elseBody) {
        return switch (elseBody.kind()) {
            case SyntaxKind.ELSE_BLOCK -> this.analyzeElseBody((Node)((ElseBlockNode)elseBody).elseBody());
            case SyntaxKind.BLOCK_STATEMENT -> {
                ArrayList<SequenceNode> elseNodes = new ArrayList<SequenceNode>();
                for (StatementNode statement : ((BlockStatementNode)elseBody).statements()) {
                    statement.accept((NodeVisitor)this);
                    elseNodes.add(this.buildNode());
                }
                yield elseNodes;
            }
            case SyntaxKind.IF_ELSE_STATEMENT -> {
                elseBody.accept((NodeVisitor)this);
                yield List.of(this.buildNode());
            }
            default -> new ArrayList<SequenceNode>();
        };
    }

    public void visit(WhileStatementNode whileStatementNode) {
        this.nodeBuilder.location((Node)whileStatementNode).kind(SequenceNode.NodeKind.WHILE).property("condition", (Node)whileStatementNode.condition());
        ArrayList<SequenceNode> bodyBlockNodes = new ArrayList<SequenceNode>();
        this.startBranch();
        for (StatementNode statement : whileStatementNode.whileBody().statements()) {
            statement.accept((NodeVisitor)this);
            this.addNode(bodyBlockNodes, (Node)statement);
        }
        this.endBranch();
        this.nodeBuilder.branch("Body", bodyBlockNodes);
        this.appendNode();
    }

    public List<SequenceNode> getSequenceNodes() {
        return this.sequenceNodes;
    }

    private void appendNode() {
        if (this.nodeBuilderStack.isEmpty()) {
            this.sequenceNodes.add(this.buildNode());
        }
    }

    private void startBranch() {
        this.nodeBuilderStack.push(this.nodeBuilder);
        this.nodeBuilder = new SequenceNode.Builder(this.semanticModel);
    }

    private void endBranch() {
        this.nodeBuilder = this.nodeBuilderStack.pop();
    }

    private SequenceNode buildNode() {
        SequenceNode sequenceNode = this.nodeBuilder.build();
        this.nodeBuilder = new SequenceNode.Builder(this.semanticModel);
        return sequenceNode;
    }

    private void addNode(List<SequenceNode> nodeList, Node node) {
        if (this.nodeBuilder.hasModified()) {
            nodeList.add(this.buildNode());
        }
    }
}

