/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.sequencemodelgenerator.core.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.sequencemodelgenerator.core.CommonUtil;

public record Expression(String type, String value) {

    public static class Factory {
        private static final String STRING_TYPE = "string";

        private Factory() {
        }

        public static Expression create(SemanticModel semanticModel, Node node) {
            String nodeString = Factory.getNodeString(node);
            return semanticModel.typeOf(node).map(symbol -> new Expression(CommonUtil.getTypeSignature(symbol), nodeString)).orElseGet(() -> new Expression(null, nodeString));
        }

        public static Expression create(SemanticModel semanticModel, Node typeNode, Node valueNode) {
            String nodeString = Factory.getNodeString(valueNode);
            return semanticModel.typeOf(typeNode).map(symbol -> new Expression(CommonUtil.getTypeSignature(symbol), nodeString)).orElseGet(() -> new Expression(null, nodeString));
        }

        public static Expression createStringType(Node node) {
            return new Expression(STRING_TYPE, Factory.getNodeString(node));
        }

        public static Expression createType(SemanticModel semanticModel, Node node, boolean ignoreNil) {
            return semanticModel.typeOf(node).filter(symbol -> ignoreNil && symbol.typeKind() != TypeDescKind.NIL).map(symbol -> new Expression(CommonUtil.getTypeSignature(symbol), null)).orElseGet(() -> null);
        }

        private static String getNodeString(Node node) {
            return node.toString().strip();
        }
    }
}

