/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.ballerinalang.bindgen.model.BFunction;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JConstructor
extends BFunction {
    private final Class<?> parentClass;
    private String exceptionName;
    private String shortClassName;
    private String exceptionConstName;
    private final Constructor<?> constructor;
    private boolean returnError = false;
    private boolean hasException = false;
    private boolean handleException = false;
    private boolean javaArraysModule = false;
    private final List<JParameter> parameters = new ArrayList<JParameter>();
    private final StringBuilder paramTypes = new StringBuilder();
    private final Set<String> importedPackages = new HashSet<String>();

    JConstructor(Constructor<?> c, BindgenEnv env, JClass jClass, String constructorName) {
        super(BFunction.BFunctionKind.CONSTRUCTOR, env);
        this.constructor = c;
        this.parentClass = c.getDeclaringClass();
        super.setDeclaringClass(this.parentClass);
        this.shortClassName = BindgenUtils.getAlias(c.getDeclaringClass(), env.getAliases());
        this.shortClassName = this.getExceptionName(jClass.getCurrentClass(), this.shortClassName);
        this.setExternalReturnType("handle");
        for (Parameter parameter : c.getParameters()) {
            JParameter parameter2 = new JParameter(parameter, this.parentClass, env);
            this.parameters.add(parameter2);
            BindgenUtils.addImportedPackage(parameter.getType(), this.importedPackages);
            this.paramTypes.append(BindgenUtils.getAlias(parameter.getType(), env.getAliases()).toLowerCase(Locale.ENGLISH));
            if (!parameter2.getIsPrimitiveArray().booleanValue() && !parameter.getType().isArray()) continue;
            this.javaArraysModule = true;
            this.returnError = true;
            this.hasException = true;
        }
        for (AnnotatedElement annotatedElement : c.getExceptionTypes()) {
            try {
                if (this.getClass().getClassLoader().loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom((Class<?>)annotatedElement)) continue;
                JError jError = new JError((Class<?>)annotatedElement);
                this.exceptionName = jError.getShortExceptionName();
                this.exceptionConstName = jError.getExceptionConstName();
                if (env.getModulesFlag()) {
                    this.exceptionName = this.getPackageAlias(this.exceptionName, (Class<?>)annotatedElement);
                    this.exceptionConstName = this.getPackageAlias(this.exceptionConstName, (Class<?>)annotatedElement);
                }
                env.setExceptionList(jError);
                this.setThrowable(jError);
                this.hasException = true;
                this.handleException = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.setErrorType(this.exceptionName);
        this.setFunctionName(constructorName);
        this.setExternalFunctionName(this.parentClass.getName().replace(".", "_").replace("$", "_") + "_" + constructorName);
    }

    private String getExceptionName(Class<?> exception, String name) {
        try {
            if (this.getClass().getClassLoader().loadClass(Exception.class.getCanonicalName()).isAssignableFrom(exception)) {
                return "J" + name;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return name;
    }

    private String getPackageAlias(String shortClassName, Class<?> objectType) {
        if (objectType.getPackage() != this.parentClass.getPackage()) {
            return objectType.getPackageName().replace(".", "") + ":" + shortClassName;
        }
        return shortClassName;
    }

    String getParamTypes() {
        return this.paramTypes.toString();
    }

    boolean requireJavaArrays() {
        return this.javaArraysModule;
    }

    Set<String> getImportedPackages() {
        return this.importedPackages;
    }

    @Override
    public List<JParameter> getParameters() {
        return this.parameters;
    }

    public String getFunctionReturnType() {
        StringBuilder returnString = new StringBuilder();
        returnString.append(this.shortClassName);
        if (this.hasException) {
            if (this.handleException) {
                returnString.append("|").append(this.exceptionName);
            }
            if (this.returnError) {
                returnString.append("|error");
            }
        }
        return returnString.toString();
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public String getExceptionConstName() {
        return this.exceptionConstName;
    }

    @Override
    public String getReturnType() {
        return this.shortClassName;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

