/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Field;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.bindgen.model.BFunction;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JField
extends BFunction {
    private final String fieldName;
    private final String fieldType;
    private String fieldMethodName;
    private boolean isArray;
    private final boolean isStatic;
    private boolean isString;
    private boolean isStringArray;
    private boolean isObject = true;
    private boolean isObjectArray;
    private boolean returnError = false;
    private boolean javaArraysModule = false;
    private final JParameter fieldObj;

    JField(Field field, BFunction.BFunctionKind fieldKind, BindgenEnv env, JClass jClass) {
        super(fieldKind, env);
        Class<?> type = field.getType();
        this.fieldType = BindgenUtils.getBallerinaParamType(type, env);
        this.isStatic = BindgenUtils.isStaticField(field);
        super.setStatic(this.isStatic);
        this.fieldName = field.getName();
        this.fieldObj = new JParameter(type, jClass.getCurrentClass(), env);
        this.setDeclaringClass(jClass.getCurrentClass());
        if (type.isPrimitive() || type.equals(String.class)) {
            this.isObject = false;
        }
        if (this.fieldType.equals("string") || this.fieldType.equals("string?")) {
            this.isString = true;
        }
        if (this.fieldType.equals("string[]") || this.fieldType.equals("string?[]?")) {
            this.isStringArray = true;
        }
        if (type.isArray()) {
            this.isArray = true;
            this.returnError = true;
            if (!type.getComponentType().isPrimitive()) {
                this.isObject = false;
                if (type.getComponentType().equals(String.class)) {
                    this.isStringArray = true;
                } else {
                    this.isObjectArray = true;
                }
            }
            this.javaArraysModule = true;
        }
        if (fieldKind == BFunction.BFunctionKind.FIELD_GET) {
            this.fieldMethodName = "get" + StringUtils.capitalize((String)this.fieldName);
        } else if (fieldKind == BFunction.BFunctionKind.FIELD_SET) {
            this.setParameters(Collections.singletonList(this.fieldObj));
            this.fieldMethodName = "set" + StringUtils.capitalize((String)this.fieldName);
        }
        this.setExternalReturnType(BindgenUtils.getBallerinaHandleType(env, type));
        this.setExternalFunctionName(jClass.getCurrentClass().getName().replace(".", "_").replace("$", "_") + "_" + this.fieldMethodName);
        this.setReturnType(this.fieldType);
        if (this.isStatic) {
            super.setFunctionName(jClass.getShortClassName() + "_" + this.fieldMethodName);
        } else {
            super.setFunctionName(this.fieldMethodName);
        }
    }

    public boolean isString() {
        return this.isString;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    boolean requireJavaArrays() {
        return this.javaArraysModule;
    }

    public String getFunctionReturnType() {
        StringBuilder returnString = new StringBuilder();
        if (super.getKind() == BFunction.BFunctionKind.FIELD_GET) {
            returnString.append(this.fieldObj.getShortTypeName());
            if (this.returnError) {
                returnString.append("|error");
            }
        }
        return returnString.toString();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isStringArray() {
        return this.isStringArray;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public boolean isObjectArray() {
        return this.isObjectArray;
    }

    public String getReturnShortName() {
        return this.fieldObj.getShortTypeName();
    }
}

