/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenFileGenerator;
import org.ballerinalang.bindgen.utils.ChildFirstClassLoader;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public final class BindgenUtils {
    private static PrintStream errStream;
    private static PrintStream outStream;
    private static final String HAS_DIAGNOSTICS_ERROR = "syntax tree generated contains diagnostic errors";

    private BindgenUtils() {
    }

    public static void outputSyntaxTreeFile(JError jError, BindgenEnv bindgenEnv, String outPath, Boolean append) throws BindgenException {
        SyntaxTree syntaxTree = new BindgenFileGenerator(bindgenEnv).generate(jError);
        if (syntaxTree.hasDiagnostics()) {
            bindgenEnv.setFailedClassGens(jError.getShortExceptionName(), HAS_DIAGNOSTICS_ERROR);
        } else {
            BindgenUtils.printOutputFile(syntaxTree.toSourceCode(), outPath, append);
        }
    }

    public static void outputSyntaxTreeFile(JClass jClass, BindgenEnv bindgenEnv, String outPath, Boolean append) throws BindgenException {
        SyntaxTree syntaxTree = new BindgenFileGenerator(bindgenEnv).generate(jClass);
        if (syntaxTree.hasDiagnostics()) {
            bindgenEnv.setFailedClassGens(jClass.getCurrentClass().getName(), HAS_DIAGNOSTICS_ERROR);
        } else {
            BindgenUtils.printOutputFile(syntaxTree.toSourceCode(), outPath, append);
        }
    }

    private static void printOutputFile(String content, String outPath, boolean append) throws BindgenException {
        try (FileWriterWithEncoding fileWriter = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setPath(outPath)).setCharset(StandardCharsets.UTF_8)).setAppend(append).get();
             PrintWriter writer = new PrintWriter((Writer)fileWriter);){
            writer.println(Formatter.format((String)content));
        }
        catch (IOException | FormatterException e) {
            throw new BindgenException("error: unable to create the file: " + outPath + " " + e.getMessage(), e);
        }
    }

    public static void createDirectory(String path) throws BindgenException {
        File directory = new File(path);
        if (!directory.exists()) {
            try {
                boolean mkdirResult = directory.mkdirs();
                if (!mkdirResult) {
                    throw new BindgenException("error: unable to create the directory: " + path);
                }
            }
            catch (SecurityException e) {
                throw new BindgenException("error: unable to create the directory: " + path + " " + e.getMessage(), e);
            }
        }
    }

    public static Set<String> addImportedPackage(Class<?> type, Set<String> importedPackages) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (!type.isPrimitive() && type != String.class) {
            importedPackages.add(type.getPackageName());
        }
        return importedPackages;
    }

    public static boolean isPublicConstructor(Constructor<?> constructor) {
        int modifiers = constructor.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublicField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublicMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublicClass(Class<?> javaClass) {
        int modifiers = javaClass.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isStaticField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public static boolean isStaticMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public static boolean isFinalField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers);
    }

    public static String getBallerinaParamType(Class<?> javaType, BindgenEnv bindgenEnv) {
        if (javaType.isArray() && javaType.getComponentType().isPrimitive()) {
            return BindgenUtils.getPrimitiveArrayBalType(javaType.getComponentType().getSimpleName());
        }
        String returnType = BindgenUtils.getBalType(bindgenEnv, BindgenUtils.getAlias(javaType, bindgenEnv.getAliases()));
        if (!returnType.equals("handle")) {
            return returnType;
        }
        String objectType = BindgenUtils.getAlias(javaType, bindgenEnv.getAliases());
        if (javaType.isArray() && (bindgenEnv.isOptionalTypes() || bindgenEnv.isOptionalParamTypes())) {
            return objectType.replace("[]", "?[]?");
        }
        if (bindgenEnv.isOptionalTypes() || bindgenEnv.isOptionalParamTypes()) {
            return objectType + "?";
        }
        return objectType;
    }

    public static String getBallerinaHandleType(BindgenEnv env, Class<?> javaType) {
        String type = javaType.getSimpleName();
        String returnType = BindgenUtils.getBalType(env, type);
        if (type.equals("String") || type.equals("String[]")) {
            returnType = "handle";
        }
        return returnType;
    }

    public static String getBallerinaReturnType(BindgenEnv bindgenEnv, Class<?> javaType) {
        if (javaType.isArray() && javaType.getComponentType().isPrimitive()) {
            return BindgenUtils.getPrimitiveArrayBalType(javaType.getComponentType().getSimpleName());
        }
        String returnType = BindgenUtils.getBalType(bindgenEnv, BindgenUtils.getAlias(javaType, bindgenEnv.getAliases()));
        if (returnType.equals("handle")) {
            String objectType = BindgenUtils.getAlias(javaType, bindgenEnv.getAliases());
            if (bindgenEnv.isOptionalTypes() || bindgenEnv.isOptionalReturnTypes()) {
                return objectType + "?";
            }
            return objectType;
        }
        return returnType;
    }

    public static String getBalReturnType(BindgenEnv env, Class<?> javaType) {
        if (javaType.isArray()) {
            javaType = javaType.getComponentType();
        }
        if (javaType.isPrimitive()) {
            return javaType.getSimpleName();
        }
        if (javaType.getSimpleName().equals("String")) {
            if (env.isOptionalTypes() || env.isOptionalReturnTypes()) {
                return "string?";
            }
            return "String";
        }
        return "handle";
    }

    private static String getBalType(BindgenEnv env, String type) {
        switch (type) {
            case "int": 
            case "short": 
            case "char": 
            case "long": {
                return "int";
            }
            case "float": 
            case "double": {
                return "float";
            }
            case "boolean": {
                return "boolean";
            }
            case "byte": {
                return "byte";
            }
            case "String": {
                if (env.isOptionalTypes() || env.isOptionalReturnTypes()) {
                    return "string?";
                }
                return "string";
            }
            case "String[]": {
                if (env.isOptionalTypes() || env.isOptionalReturnTypes()) {
                    return "string?[]?";
                }
                return "string[]";
            }
        }
        return "handle";
    }

    private static String getPrimitiveArrayBalType(String type) {
        return switch (type) {
            case "int", "short", "char", "long" -> "int[]";
            case "float", "double" -> "float[]";
            case "boolean" -> "boolean[]";
            case "byte" -> "byte[]";
            default -> "handle";
        };
    }

    public static String getPrimitiveArrayType(String type) {
        return switch (type) {
            case "[C", "[S", "[J", "[I" -> "int[]";
            case "[D", "[F" -> "float[]";
            case "[B" -> "byte[]";
            case "[Z" -> "boolean[]";
            default -> type;
        };
    }

    public static URLClassLoader getClassLoader(Set<String> jarPaths, ClassLoader parent) throws BindgenException {
        URLClassLoader classLoader;
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            ArrayList<String> classPaths = new ArrayList<String>();
            ArrayList<String> failedClassPaths = new ArrayList<String>();
            for (String path : jarPaths) {
                File file = FileSystems.getDefault().getPath(path, new String[0]).toFile();
                if (file.isDirectory()) {
                    File[] paths = file.listFiles();
                    if (paths != null) {
                        for (File filePath : paths) {
                            if (!BindgenUtils.isJarFile(filePath)) continue;
                            urls.add(filePath.toURI().toURL());
                            classPaths.add(filePath.getName());
                        }
                        continue;
                    }
                    failedClassPaths.add(path);
                    continue;
                }
                if (BindgenUtils.isJarFile(file)) {
                    urls.add(file.toURI().toURL());
                    classPaths.add(file.getName());
                    continue;
                }
                failedClassPaths.add(file.toString());
            }
            if (!classPaths.isEmpty()) {
                outStream.println("\nThe following JARs were added to the classpath:");
                for (String path : classPaths) {
                    outStream.println("\t" + path);
                }
            }
            if (!failedClassPaths.isEmpty()) {
                errStream.println("\nFailed to add the following to classpath:");
                for (String path : failedClassPaths) {
                    outStream.println("\t" + path);
                }
            }
            classLoader = (URLClassLoader)AccessController.doPrivileged(() -> new ChildFirstClassLoader(urls.toArray(new URL[0]), parent));
        }
        catch (RuntimeException e) {
            throw new BindgenException("error: unable to load the provided classpaths: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new BindgenException("error: unable to process the provided classpaths: " + e.getMessage(), e);
        }
        return classLoader;
    }

    private static boolean isJarFile(File file) {
        String fileName = file.getName();
        return file.isFile() && fileName.substring(fileName.lastIndexOf(46)).equals(".jar");
    }

    public static void setErrStream(PrintStream errStream) {
        BindgenUtils.errStream = errStream;
    }

    public static void setOutStream(PrintStream outStream) {
        BindgenUtils.outStream = outStream;
    }

    public static String getAlias(Class<?> className, Map<String, String> aliases) {
        if (!aliases.containsKey(className.getName())) {
            int i = 2;
            boolean notAdded = true;
            String simpleName = className.getSimpleName();
            Object alias = simpleName;
            if (!aliases.containsValue(alias)) {
                aliases.put(className.getName(), (String)alias);
            } else {
                while (notAdded) {
                    if (className.isArray()) {
                        int insertInto = simpleName.toCharArray().length - 2;
                        alias = simpleName.substring(0, insertInto) + i + simpleName.substring(insertInto);
                    } else {
                        alias = simpleName + i;
                    }
                    if (!aliases.containsValue(alias)) {
                        aliases.put(className.getName(), (String)alias);
                        notAdded = false;
                    }
                    ++i;
                }
            }
        }
        return aliases.get(className.getName());
    }
}

