/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.mockextension;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.EventData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BMockSpan {
    private String operationName;
    private String traceId;
    private String spanId;
    private String parentId;
    private Map<String, Object> tags;
    private List<BMockEvent> events;

    public BMockSpan(String operationName, String traceId, String spanId, String parentId, Map<String, Object> tags, List<BMockEvent> events) {
        this.operationName = operationName;
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.tags = tags;
        this.events = events;
    }

    public BMockSpan(String operationName, String traceId, String spanId, String parentId, Attributes attributes, List<EventData> eventDataList) {
        this.operationName = operationName;
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.tags = new HashMap<String, Object>();
        attributes.forEach((attributeKey, o) -> this.tags.put(attributeKey.getKey(), o));
        this.events = new ArrayList<BMockEvent>();
        for (EventData eventData : eventDataList) {
            HashMap tags = new HashMap();
            eventData.getAttributes().forEach((attributeKey, o) -> tags.put(attributeKey.getKey(), o));
            this.events.add(new BMockEvent(eventData.getName(), eventData.getEpochNanos(), tags));
        }
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public List<BMockEvent> getEvents() {
        return this.events;
    }

    public List<CheckPoint> getCheckpoints() {
        ArrayList<CheckPoint> checkpoints = null;
        if (this.getEvents() != null) {
            checkpoints = new ArrayList<CheckPoint>(this.getEvents().size());
            for (BMockEvent mockEvent : this.getEvents()) {
                if (!mockEvent.getName().equals("CHECKPOINT")) continue;
                CheckPoint checkpoint = new CheckPoint(mockEvent.getTags().get("src.module").toString(), mockEvent.getTags().get("src.position").toString());
                checkpoints.add(checkpoint);
            }
        }
        return checkpoints;
    }

    public static final class BMockEvent {
        private final String name;
        private final long timestampMicros;
        private final Map<String, ?> tags;

        public BMockEvent(String name, long timestampMicros, Map<String, ?> tags) {
            this.name = name;
            this.timestampMicros = timestampMicros;
            this.tags = tags;
        }

        public String getName() {
            return this.name;
        }

        public long getTimestampMicros() {
            return this.timestampMicros;
        }

        public Map<String, ?> getTags() {
            return this.tags;
        }
    }

    public static class CheckPoint {
        private final String moduleID;
        private final String positionID;

        public CheckPoint(String moduleID, String positionID) {
            this.moduleID = moduleID;
            this.positionID = positionID;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CheckPoint that = (CheckPoint)object;
            return Objects.equals(this.moduleID, that.moduleID) && Objects.equals(this.positionID, that.positionID);
        }

        public int hashCode() {
            return Objects.hash(this.moduleID, this.positionID);
        }
    }
}

