/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.mockextension;

import io.ballerina.runtime.observability.tracer.spi.TracerProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BMockTracerProvider
implements TracerProvider {
    private static final PrintStream out = System.out;
    private static final Map<String, InMemorySpanExporter> exporterMap = new ConcurrentHashMap<String, InMemorySpanExporter>();

    public String getName() {
        return "mock";
    }

    public void init() {
    }

    public static Map<String, InMemorySpanExporter> getExporterMap() {
        return Collections.unmodifiableMap(exporterMap);
    }

    public Tracer getTracer(String serviceName) {
        InMemorySpanExporter inMemorySpanExporter = InMemorySpanExporter.create();
        exporterMap.put(serviceName, inMemorySpanExporter);
        out.println("Initialized Mock Tracer for " + serviceName);
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)inMemorySpanExporter)).build();
        return tracerProvider.get(serviceName);
    }

    public ContextPropagators getPropagators() {
        return ContextPropagators.noop();
    }
}

