/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.mockextension.typeadapter;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Duration;

public class DurationTypeAdapter
implements JsonSerializer<Duration>,
JsonDeserializer<Duration> {
    private static final Gson gson = new Gson();

    public JsonElement serialize(Duration duration, Type typeOfSrc, JsonSerializationContext context) {
        long seconds = duration.getSeconds();
        int nanos = duration.getNano();
        DurationData durationData = new DurationData(seconds, nanos);
        return gson.toJsonTree((Object)durationData);
    }

    public Duration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        DurationData data = (DurationData)gson.fromJson(json, DurationData.class);
        return Duration.ofSeconds(data.seconds(), data.nanos());
    }

    private record DurationData(long seconds, int nanos) {
    }
}

