/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.metrics.PercentileValue;
import io.ballerina.runtime.observability.metrics.Snapshot;
import io.ballerina.runtime.observability.metrics.StatisticConfig;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    static Type metricType;
    static Type statisticsConfigType;
    static Type percentileValueType;
    static Type snapshotType;

    public static void initializeModule(Environment env) {
        metricType = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"Metric").getType();
        statisticsConfigType = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"StatisticConfig").getType();
        percentileValueType = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"PercentileValue").getType();
        snapshotType = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"Snapshot").getType();
    }

    public static Map<String, String> toStringMap(BMap<BString, ?> map) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (map != null) {
            for (Map.Entry keyVals : map.entrySet()) {
                Object value = keyVals.getValue();
                returnMap.put(((BString)keyVals.getKey()).toString(), value == null ? "()" : value.toString());
            }
        }
        return returnMap;
    }

    public static BArray createBSnapshots(Environment env, Snapshot[] snapshots) {
        if (snapshots != null && snapshots.length > 0) {
            BArray bSnapshots = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)snapshotType));
            int index = 0;
            for (Snapshot snapshot : snapshots) {
                BArray bPercentiles = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)percentileValueType));
                int percentileIndex = 0;
                for (PercentileValue percentileValue : snapshot.getPercentileValues()) {
                    BMap bPercentileValue = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"PercentileValue");
                    bPercentileValue.put((Object)StringUtils.fromString((String)"percentile"), (Object)percentileValue.getPercentile());
                    bPercentileValue.put((Object)StringUtils.fromString((String)"value"), (Object)percentileValue.getValue());
                    bPercentiles.add((long)percentileIndex, (Object)bPercentileValue);
                    ++percentileIndex;
                }
                BMap aSnapshot = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"Snapshot");
                aSnapshot.put((Object)StringUtils.fromString((String)"timeWindow"), (Object)snapshot.getTimeWindow().toMillis());
                aSnapshot.put((Object)StringUtils.fromString((String)"mean"), (Object)snapshot.getMean());
                aSnapshot.put((Object)StringUtils.fromString((String)"max"), (Object)snapshot.getMax());
                aSnapshot.put((Object)StringUtils.fromString((String)"min"), (Object)snapshot.getMin());
                aSnapshot.put((Object)StringUtils.fromString((String)"stdDev"), (Object)snapshot.getStdDev());
                aSnapshot.put((Object)StringUtils.fromString((String)"percentileValues"), (Object)bPercentiles);
                bSnapshots.add((long)index, (Object)aSnapshot);
                ++index;
            }
            return bSnapshots;
        }
        return null;
    }

    public static BArray createBStatisticConfig(Environment env, StatisticConfig[] configs) {
        if (configs != null) {
            BArray bStatsConfig = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)statisticsConfigType));
            int index = 0;
            for (StatisticConfig config : configs) {
                BArray bPercentiles = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_FLOAT));
                int percentileIndex = 0;
                double[] dArray = config.getPercentiles();
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double percentile = dArray[i];
                    bPercentiles.add((long)percentileIndex, (Object)percentile);
                    ++percentileIndex;
                }
                BMap aSnapshot = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"StatisticConfig");
                aSnapshot.put((Object)StringUtils.fromString((String)"percentiles"), (Object)bPercentiles);
                aSnapshot.put((Object)StringUtils.fromString((String)"timeWindow"), (Object)config.getTimeWindow());
                aSnapshot.put((Object)StringUtils.fromString((String)"buckets"), (Object)config.getBuckets());
                bStatsConfig.add((long)index, (Object)aSnapshot);
                ++index;
            }
            return bStatsConfig;
        }
        return ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)statisticsConfigType));
    }
}

