/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli;

import io.ballerina.shell.Diagnostic;
import io.ballerina.shell.DiagnosticKind;
import io.ballerina.shell.Evaluator;
import io.ballerina.shell.ExceptionStatus;
import io.ballerina.shell.ShellCompilation;
import io.ballerina.shell.ShellReturnValue;
import io.ballerina.shell.cli.BShellConfiguration;
import io.ballerina.shell.cli.PropertiesLoader;
import io.ballerina.shell.cli.ShellExitException;
import io.ballerina.shell.cli.TerminalAdapter;
import io.ballerina.shell.cli.handlers.CommandHandler;
import io.ballerina.shell.cli.handlers.DeleteCommand;
import io.ballerina.shell.cli.handlers.ExitCommand;
import io.ballerina.shell.cli.handlers.FileCommand;
import io.ballerina.shell.cli.handlers.HelpCommand;
import io.ballerina.shell.cli.handlers.ResetStateCommand;
import io.ballerina.shell.cli.handlers.StringListCommand;
import io.ballerina.shell.cli.handlers.ToggleDebugCommand;
import io.ballerina.shell.cli.utils.FileUtils;
import io.ballerina.shell.exceptions.BallerinaShellException;
import io.ballerina.shell.utils.ModuleImporter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class BallerinaShell {
    protected final BShellConfiguration configuration;
    protected final TerminalAdapter terminal;
    protected final Evaluator evaluator;
    protected final CommandHandler commandHandler;
    protected boolean isRunning;

    public BallerinaShell(BShellConfiguration configuration, TerminalAdapter terminal) {
        this.configuration = configuration;
        this.terminal = terminal;
        this.isRunning = true;
        this.evaluator = configuration.getEvaluator();
        this.commandHandler = this.createCommandHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String leftPrompt = this.terminal.color(PropertiesLoader.getProperty("repl.prompt"), 2);
        this.terminal.println(FileUtils.readResource(PropertiesLoader.getProperty("resource.header.file")));
        Instant start = Instant.now();
        try {
            this.evaluator.initialize();
            Optional<String> startFile = this.configuration.getStartFile();
            if (startFile.isPresent()) {
                this.evaluator.evaluateDeclarationFile(startFile.get());
            }
        }
        catch (BallerinaShellException e) {
            this.terminal.println("\nShell Initialization Failed!!!");
            return;
        }
        finally {
            this.evaluator.diagnostics().forEach(this::outputDebugDiagnostic);
            this.outputDistinctErrorDiagnostics(this.evaluator.diagnostics());
            this.evaluator.resetDiagnostics();
        }
        Instant end = Instant.now();
        while (this.isRunning) {
            Duration previousDuration = Duration.between(start, end);
            String rightPrompt = String.format("took %s ms", previousDuration.toMillis());
            rightPrompt = this.terminal.color(rightPrompt, 8);
            try {
                List<Object> currentStateDiagnostics;
                String source = this.terminal.readLine(leftPrompt, rightPrompt).trim();
                start = Instant.now();
                if (this.commandHandler.handle(source)) continue;
                ShellCompilation shellCompilation = this.evaluator.getCompilation(source);
                Optional compilation = shellCompilation.getPackageCompilation();
                if (ExceptionStatus.SUCCESS == shellCompilation.getExceptionStatus()) {
                    Optional shellReturnValue = this.evaluator.getValue(compilation);
                    if (shellReturnValue.isPresent() && ((ShellReturnValue)shellReturnValue.get()).getExceptionStatus() == ExceptionStatus.SUCCESS) {
                        String result = ((ShellReturnValue)shellReturnValue.get()).getResult();
                        this.terminal.result(result);
                        continue;
                    }
                    if (!shellReturnValue.isPresent() || ((ShellReturnValue)shellReturnValue.get()).getExceptionStatus() != ExceptionStatus.INVOKER_FAILED || !this.isContainsUndefinedModules(this.evaluator.diagnostics())) continue;
                    currentStateDiagnostics = List.copyOf(this.evaluator.diagnostics());
                    this.evaluator.resetDiagnostics();
                    this.executeChanges(source, currentStateDiagnostics);
                    continue;
                }
                if (shellCompilation.getExceptionStatus() != ExceptionStatus.INVOKER_FAILED || !this.isContainsUndefinedModules(this.evaluator.diagnostics())) continue;
                currentStateDiagnostics = List.copyOf(this.evaluator.diagnostics());
                this.evaluator.resetDiagnostics();
                this.executeChanges(source, currentStateDiagnostics);
            }
            catch (ShellExitException e) {
                this.terminal.info("Bye!!!");
                this.isRunning = false;
                break;
            }
            catch (Exception e) {
                if (this.evaluator.hasErrors()) continue;
                this.terminal.fatalError("Something went wrong: " + e.getMessage());
            }
            finally {
                end = Instant.now();
                this.evaluator.diagnostics().forEach(this::outputDebugDiagnostic);
                this.outputDistinctErrorDiagnostics(this.evaluator.diagnostics());
                this.evaluator.resetDiagnostics();
                this.terminal.println("");
            }
        }
    }

    public void runFile(String fileName) {
        try {
            this.evaluator.evaluateDeclarationFile(fileName);
        }
        catch (BallerinaShellException e) {
            this.outputException((Exception)((Object)e));
        }
    }

    public void delete(List<String> declarationNames) {
        try {
            this.evaluator.delete(declarationNames);
        }
        catch (BallerinaShellException e) {
            this.outputException((Exception)((Object)e));
        }
    }

    protected void outputDebugDiagnostic(Diagnostic diagnostic) {
        DiagnosticKind diagnosticKind = diagnostic.getKind();
        if (diagnosticKind == DiagnosticKind.DEBUG && this.configuration.isDebug()) {
            this.terminal.debug(diagnostic.toString());
        }
    }

    protected void outputDistinctErrorDiagnostics(Collection<Diagnostic> diagnostics) {
        ArrayList<String> warnDiagnostics = new ArrayList<String>();
        ArrayList<String> errorDiagnostics = new ArrayList<String>();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.getKind() == DiagnosticKind.ERROR) {
                errorDiagnostics.add(diagnostic.toString());
                continue;
            }
            if (diagnostic.getKind() != DiagnosticKind.WARN) continue;
            warnDiagnostics.add(diagnostic.toString());
        }
        warnDiagnostics.stream().distinct().forEach(this.terminal::warn);
        errorDiagnostics.stream().distinct().forEach(this.terminal::error);
    }

    protected void outputException(Exception e) {
        if (this.configuration.isDebug()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            this.terminal.fatalError(stringWriter.toString());
        }
    }

    private CommandHandler createCommandHandler() {
        CommandHandler commandHandler = new CommandHandler();
        commandHandler.attach(PropertiesLoader.getProperty("commands.exit"), new ExitCommand(this));
        commandHandler.attach(PropertiesLoader.getProperty("commands.help"), new HelpCommand(this));
        commandHandler.attach(PropertiesLoader.getProperty("commands.reset"), new ResetStateCommand(this));
        commandHandler.attach(PropertiesLoader.getProperty("commands.debug"), new ToggleDebugCommand(this));
        commandHandler.attach(PropertiesLoader.getProperty("commands.file"), new FileCommand(this));
        commandHandler.attach(PropertiesLoader.getProperty("commands.delete"), new DeleteCommand(this));
        commandHandler.attach(PropertiesLoader.getProperty("commands.vars"), new StringListCommand(this, () -> ((Evaluator)this.evaluator).availableVariables()));
        commandHandler.attach(PropertiesLoader.getProperty("commands.imports"), new StringListCommand(this, () -> ((Evaluator)this.evaluator).availableImports()));
        commandHandler.attach(PropertiesLoader.getProperty("commands.dclns"), new StringListCommand(this, () -> ((Evaluator)this.evaluator).availableModuleDeclarations()));
        return commandHandler;
    }

    public void outputInfo(String text) {
        this.terminal.info(text);
    }

    public void outputError(String text) {
        this.terminal.error(text);
    }

    public boolean toggleDebug() {
        this.configuration.toggleDebug();
        return this.configuration.isDebug();
    }

    public void reset() {
        try {
            this.evaluator.reset();
            this.evaluator.initialize();
        }
        catch (BallerinaShellException e) {
            throw new RuntimeException(e);
        }
    }

    public void importModules(ModuleImporter moduleImporter, List<String> modules) {
        ArrayList<String> missingModules = new ArrayList<String>();
        ArrayList<String> requiredModules = new ArrayList<String>();
        this.terminal.info("\nFound following undefined module(s).");
        for (String string : modules) {
            String string2 = string.replace("'", "");
            if (moduleImporter.isModuleInDistRepo(string2)) {
                requiredModules.add(string2);
            } else {
                missingModules.add(string2);
            }
            this.terminal.info(string2);
        }
        if (!requiredModules.isEmpty()) {
            this.terminal.info("\nFollowing undefined modules can be imported.");
            int moduleCount = 1;
            for (String string : requiredModules) {
                this.terminal.info(String.format("%d. %s", moduleCount, string));
                ++moduleCount;
            }
            String string = this.terminal.readOneLine("Do you want to import mentioned modules (yes/y) (no/n)? ");
            if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y")) {
                for (String string3 : requiredModules) {
                    String importSource = moduleImporter.getImportStatement(string3);
                    this.terminal.info("\nAdding import: " + importSource);
                    try {
                        ShellCompilation shellCompilation = this.evaluator.getCompilation(importSource);
                        Optional compilation = shellCompilation.getPackageCompilation();
                        this.evaluator.getValue(compilation);
                        this.terminal.info("Import added: " + importSource);
                    }
                    catch (BallerinaShellException ex) {
                        this.terminal.error("Error occurred while adding imports.");
                        this.outputException((Exception)((Object)ex));
                    }
                }
                if (!missingModules.isEmpty()) {
                    this.terminal.error("\nFound following missing module(s).");
                    for (String string4 : missingModules) {
                        this.terminal.error(string4);
                    }
                }
            } else {
                this.terminal.error("\nFound missing module(s).");
            }
        } else {
            this.terminal.error("\nFound missing module(s).");
        }
    }

    public boolean addImports(Collection<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            if (!diagnostic.toString().contains("undefined module")) continue;
            return true;
        }
        return false;
    }

    public boolean isContainsUndefinedModules(Collection<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            if (!diagnostic.toString().contains("undefined module")) continue;
            return true;
        }
        return false;
    }

    private void executeChanges(String source, Collection<Diagnostic> diagnostics) {
        ModuleImporter moduleImporter = new ModuleImporter();
        List modules = moduleImporter.undefinedModules(diagnostics);
        if (!modules.isEmpty()) {
            this.importModules(moduleImporter, modules);
            try {
                this.terminal.println("");
                ShellCompilation shellCompilation = this.evaluator.getCompilation(source);
                Optional compilation = shellCompilation.getPackageCompilation();
                ShellReturnValue shellReturnValue = (ShellReturnValue)this.evaluator.getValue(compilation).get();
                String result = shellReturnValue.getResult();
                this.terminal.result(result);
            }
            catch (BallerinaShellException error) {
                this.terminal.error("\nCompilation aborted due to errors.");
            }
            catch (Exception e) {
                throw e;
            }
        }
    }
}

