/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli;

import io.ballerina.shell.cli.BShellConfiguration;
import io.ballerina.shell.cli.BallerinaShell;
import io.ballerina.shell.cli.PropertiesLoader;
import io.ballerina.shell.cli.jline.DumbJlineTerminalAdapter;
import io.ballerina.shell.cli.jline.JlineBallerinaParser;
import io.ballerina.shell.cli.jline.JlineSimpleCompleter;
import io.ballerina.shell.cli.jline.JlineTerminalAdapter;
import org.jline.reader.Completer;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public final class ReplShellApplication {
    private ReplShellApplication() {
    }

    public static void execute(BShellConfiguration configuration) throws Exception {
        JlineTerminalAdapter terminalAdapter;
        Terminal terminal;
        if (configuration.isDumb()) {
            terminal = TerminalBuilder.builder().streams(configuration.getInputStream(), configuration.getOutputStream()).jna(false).jansi(false).dumb(true).build();
        } else {
            terminal = TerminalBuilder.terminal();
            configuration.setDumb(terminal.getType().equals("dumb"));
        }
        if (configuration.isDumb()) {
            LineReader lineReader = LineReaderBuilder.builder().appName(PropertiesLoader.getProperty("app.name")).terminal(terminal).build();
            terminalAdapter = new DumbJlineTerminalAdapter(lineReader);
        } else {
            JlineSimpleCompleter completer = new JlineSimpleCompleter();
            DefaultHighlighter highlighter = new DefaultHighlighter();
            JlineBallerinaParser parser = new JlineBallerinaParser();
            LineReader lineReader = LineReaderBuilder.builder().variable("secondary-prompt-pattern", (Object)"%P > ").appName(PropertiesLoader.getProperty("app.name")).highlighter((Highlighter)highlighter).completer((Completer)completer).terminal(terminal).parser((Parser)parser).build();
            terminalAdapter = new JlineTerminalAdapter(lineReader);
        }
        BallerinaShell shell = new BallerinaShell(configuration, terminalAdapter);
        shell.run();
    }

    public static void main(String ... args) throws Exception {
        BShellConfiguration configuration = new BShellConfiguration.Builder().build();
        ReplShellApplication.execute(configuration);
    }
}

