/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli;

import io.ballerina.shell.cli.ShellExitException;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class TerminalAdapter {
    protected static final int BLACK = 0;
    protected static final int RED = 1;
    protected static final int GREEN = 2;
    protected static final int YELLOW = 3;
    protected static final int BLUE = 4;
    protected static final int MAGENTA = 5;
    protected static final int CYAN = 6;
    protected static final int WHITE = 7;
    protected static final int BRIGHT = 8;
    private static final String NEWLINE = "\n";

    protected abstract String color(String var1, int var2);

    public abstract String readLine(String var1, String var2) throws ShellExitException;

    public abstract void println(String var1);

    public void result(String text) {
        if (text != null) {
            this.println(this.color(text, 12));
        }
    }

    public void error(String text) {
        this.println(this.color(this.indented(text), 9));
    }

    public void warn(String text) {
        this.println(this.color(this.indented(text), 3));
    }

    public void debug(String text) {
        this.println(this.color(this.indented(text), 8));
    }

    public void fatalError(String text) {
        this.println(this.color(this.indented(text), 1));
    }

    public void info(String text) {
        this.println(this.color(this.indented(text), 6));
    }

    private String indented(String text) {
        return Arrays.stream(text.split(NEWLINE)).map(s -> "| " + s).collect(Collectors.joining(NEWLINE));
    }

    public abstract String readOneLine(String var1);
}

