/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.handlers.help;

import io.ballerina.shell.cli.handlers.help.HelpProviderException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BbeHelpProvider {
    private static final String BALLERINA_HOME = System.getProperty("ballerina.home");
    private static final String EXAMPLES = "examples";
    private static final String MD_FILE = ".md";
    private static final String REMOVABLE_CHARACTERS = ":::";

    public String getDescription(String topic) throws HelpProviderException {
        String topicUrl = topic.replace(" ", "-");
        String bbePrefix = BALLERINA_HOME + File.separator + EXAMPLES + File.separator;
        String bbePath = bbePrefix + topicUrl + File.separator + String.join((CharSequence)"_", topicUrl.split("-")) + MD_FILE;
        String description = BbeHelpProvider.readFileAsString(bbePath).trim();
        Stream<String> stringStream = Arrays.stream(description.split("\n")).filter(line -> !line.startsWith(REMOVABLE_CHARACTERS));
        return stringStream.collect(Collectors.joining("\n"));
    }

    private static String readFileAsString(String file) throws HelpProviderException {
        String content;
        try {
            content = Files.readString(Path.of(file, new String[0]));
        }
        catch (IOException e) {
            throw new HelpProviderException("Error occurred while executing the command");
        }
        return content;
    }
}

