/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.jline;

import io.ballerina.shell.cli.jline.JlineParsedLine;
import io.ballerina.shell.cli.jline.parser.ParserStateMachine;
import io.ballerina.shell.cli.jline.validator.InputValidator;
import java.util.LinkedList;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;

public class JlineBallerinaParser
implements Parser {
    private static final char SPACE = ' ';
    private static final char NEW_LINE = '\n';
    private static final InputValidator inputValidator = new InputValidator();

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        if (line == null) {
            throw new EOFError(-1, -1, "line was not provided");
        }
        LinkedList<String> words = new LinkedList<String>();
        StringBuilder currentWord = new StringBuilder();
        int wordCursor = -1;
        int wordIndex = -1;
        ParserStateMachine stateMachine = new ParserStateMachine();
        for (int i = 0; i < line.length(); ++i) {
            char character = line.charAt(i);
            if (i == cursor) {
                wordIndex = words.size();
                wordCursor = currentWord.length();
            }
            currentWord.append(character);
            if (character == ' ') {
                words.add(currentWord.toString());
                currentWord.setLength(0);
            }
            stateMachine.feed(character);
        }
        if (!currentWord.isEmpty() || cursor == line.length()) {
            words.add(currentWord.toString());
        }
        if (cursor == line.length()) {
            wordIndex = words.size() - 1;
            wordCursor = ((String)words.get(words.size() - 1)).length();
        }
        stateMachine.feed('\n');
        if (context != Parser.ParseContext.COMPLETE && !inputValidator.isComplete(line)) {
            throw new EOFError(-1, -1, "incomplete line");
        }
        return new JlineParsedLine(line, words, wordIndex, wordCursor, cursor);
    }

    public boolean isEscapeChar(char ch) {
        return false;
    }
}

