/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.jline;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.ParsedLine;

public class JlineParsedLine
implements ParsedLine,
CompletingParsedLine {
    private final String line;
    private final List<String> words;
    private final int wordIndex;
    private final int wordCursor;
    private final int cursor;

    public JlineParsedLine(String line, List<String> words, int wordIndex, int wordCursor, int cursor) {
        this.line = line;
        this.words = Collections.unmodifiableList(Objects.requireNonNull(words));
        this.wordIndex = wordIndex;
        this.wordCursor = wordCursor;
        this.cursor = cursor;
    }

    public int wordIndex() {
        return this.wordIndex;
    }

    public String word() {
        if (0 <= this.wordIndex && this.wordIndex < this.words.size()) {
            return this.words.get(this.wordIndex);
        }
        return "";
    }

    public int wordCursor() {
        return this.wordCursor;
    }

    public List<String> words() {
        return this.words;
    }

    public int cursor() {
        return this.cursor;
    }

    public String line() {
        return this.line;
    }

    public CharSequence escape(CharSequence candidate, boolean complete) {
        return candidate;
    }

    public int rawWordCursor() {
        return this.wordCursor;
    }

    public int rawWordLength() {
        return this.word().length();
    }
}

