/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.utils;

import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.CollectClauseNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingBindingPatternNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarator;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import java.util.stream.StreamSupport;

public class IncompleteInputFinder
extends NodeTransformer<Boolean> {
    public Boolean transform(SimpleNameReferenceNode node) {
        return node.name().isMissing() || node.hasDiagnostics();
    }

    public Boolean transform(BuiltinSimpleNameReferenceNode node) {
        return node.name().isMissing() || node.hasDiagnostics();
    }

    public Boolean transform(BinaryExpressionNode node) {
        return (Boolean)node.rhsExpr().apply((NodeTransformer)this);
    }

    public Boolean transform(FunctionDefinitionNode node) {
        return node.functionKeyword().isMissing() || (Boolean)node.functionSignature().apply((NodeTransformer)this) != false || (Boolean)node.functionBody().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(FunctionSignatureNode node) {
        return node.openParenToken().isMissing() || node.closeParenToken().isMissing();
    }

    public Boolean transform(FunctionBodyBlockNode node) {
        return node.openBraceToken().isMissing() || node.closeBraceToken().isMissing();
    }

    public Boolean transform(ExplicitAnonymousFunctionExpressionNode node) {
        return (Boolean)node.functionBody().apply((NodeTransformer)this);
    }

    public Boolean transform(BasicLiteralNode basicLiteralNode) {
        return false;
    }

    public Boolean transform(ExpressionFunctionBodyNode node) {
        return (Boolean)node.expression().apply((NodeTransformer)this);
    }

    public Boolean transform(ListConstructorExpressionNode node) {
        return node.closeBracket().isMissing();
    }

    public Boolean transform(IfElseStatementNode node) {
        return node.ifKeyword().isMissing() || node.ifBody().openBraceToken().isMissing() || node.ifBody().closeBraceToken().isMissing();
    }

    public Boolean transform(WhileStatementNode node) {
        return node.whileKeyword().isMissing() || node.whileBody().openBraceToken().isMissing() || node.whileBody().closeBraceToken().isMissing();
    }

    public Boolean transform(ForEachStatementNode node) {
        return node.forEachKeyword().isMissing() || node.inKeyword().isMissing() || node.blockStatement().openBraceToken().isMissing() || node.blockStatement().closeBraceToken().isMissing();
    }

    public Boolean transform(VariableDeclarationNode node) {
        if (node.initializer().isPresent()) {
            return ((Token)node.equalsToken().get()).isMissing() || (Boolean)((ExpressionNode)node.initializer().get()).apply((NodeTransformer)this) != false || (Boolean)node.typedBindingPattern().typeDescriptor().apply((NodeTransformer)this) != false;
        }
        if (node.equalsToken().isPresent()) {
            return ((Token)node.equalsToken().get()).isMissing() || (Boolean)node.typedBindingPattern().typeDescriptor().apply((NodeTransformer)this) != false || (Boolean)node.typedBindingPattern().bindingPattern().apply((NodeTransformer)this) != false;
        }
        return (Boolean)node.typedBindingPattern().typeDescriptor().apply((NodeTransformer)this) != false || (Boolean)node.typedBindingPattern().bindingPattern().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(MappingBindingPatternNode node) {
        return node.closeBrace().isMissing();
    }

    public Boolean transform(ModuleVariableDeclarationNode node) {
        if (StreamSupport.stream(node.diagnostics().spliterator(), false).anyMatch(diagnostic -> diagnostic.diagnosticInfo().code().equals("BCE0524"))) {
            return false;
        }
        if (node.initializer().isPresent()) {
            return ((Token)node.equalsToken().get()).isMissing() || (Boolean)((ExpressionNode)node.initializer().get()).apply((NodeTransformer)this) != false || (Boolean)node.typedBindingPattern().typeDescriptor().apply((NodeTransformer)this) != false;
        }
        if (node.equalsToken().isPresent()) {
            return ((Token)node.equalsToken().get()).isMissing() || (Boolean)node.typedBindingPattern().typeDescriptor().apply((NodeTransformer)this) != false;
        }
        if (!node.equalsToken().isPresent()) {
            return true;
        }
        return (Boolean)node.typedBindingPattern().typeDescriptor().apply((NodeTransformer)this);
    }

    public Boolean transform(ParenthesisedTypeDescriptorNode node) {
        return node.closeParenToken().isMissing() || node.closeParenToken().hasDiagnostics() || node.openParenToken().hasDiagnostics();
    }

    public Boolean transform(BlockStatementNode node) {
        if (node.openBraceToken().isMissing() || node.closeBraceToken().isMissing()) {
            return true;
        }
        if (!node.statements().isEmpty()) {
            return (Boolean)((StatementNode)node.statements().get(0)).apply((NodeTransformer)this);
        }
        return true;
    }

    public Boolean transform(ExpressionStatementNode node) {
        return (Boolean)node.expression().apply((NodeTransformer)this);
    }

    public Boolean transform(TypeDefinitionNode node) {
        return (Boolean)node.typeDescriptor().apply((NodeTransformer)this);
    }

    public Boolean transform(RecordTypeDescriptorNode node) {
        return node.bodyStartDelimiter().isMissing() || node.bodyEndDelimiter().isMissing();
    }

    public Boolean transform(MappingConstructorExpressionNode node) {
        return node.closeBrace().isMissing();
    }

    public Boolean transform(QueryExpressionNode node) {
        return node.queryPipeline().fromClause().fromKeyword().isMissing() || node.resultClause().kind() == SyntaxKind.SELECT_CLAUSE ? (Boolean)((SelectClauseNode)node.resultClause()).expression().apply((NodeTransformer)this) : (Boolean)((CollectClauseNode)node.resultClause()).expression().apply((NodeTransformer)this);
    }

    public Boolean transform(SelectClauseNode node) {
        return (Boolean)node.expression().apply((NodeTransformer)this);
    }

    public Boolean transform(TableConstructorExpressionNode node) {
        return node.closeBracket().isMissing();
    }

    public Boolean transform(BracedExpressionNode node) {
        return node.openParen().hasDiagnostics() || node.openParen().isMissing() || node.closeParen().isMissing();
    }

    public Boolean transform(IndexedExpressionNode node) {
        return node.openBracket().isMissing() || node.closeBracket().isMissing() || (Boolean)node.containerExpression().apply((NodeTransformer)this) != false || (Boolean)((ExpressionNode)node.keyExpression().get(0)).apply((NodeTransformer)this) != false;
    }

    public Boolean transform(LetExpressionNode node) {
        return node.letKeyword().isMissing();
    }

    public Boolean transform(ServiceDeclarationNode node) {
        return node.serviceKeyword().isMissing();
    }

    public Boolean transform(ConditionalExpressionNode node) {
        return node.colonToken().isMissing() || node.questionMarkToken().isMissing();
    }

    public Boolean transform(TypeTestExpressionNode node) {
        return node.isKeyword().isMissing() || (Boolean)node.expression().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(ClassDefinitionNode node) {
        return node.classKeyword().isMissing() || node.openBrace().isMissing() || node.closeBrace().isMissing();
    }

    public Boolean transform(TypeCastExpressionNode node) {
        return node.gtToken().isMissing() || node.ltToken().isMissing();
    }

    public Boolean transform(TransactionStatementNode node) {
        return node.transactionKeyword().isMissing() || (Boolean)node.blockStatement().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(QualifiedNameReferenceNode node) {
        return node.colon().isMissing();
    }

    public Boolean transform(NamedWorkerDeclarationNode node) {
        return node.workerKeyword().isMissing() || (Boolean)node.workerBody().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(NamedWorkerDeclarator node) {
        return (Boolean)((NamedWorkerDeclarationNode)node.namedWorkerDeclarations().get(0)).workerBody().apply((NodeTransformer)this);
    }

    protected Boolean transformSyntaxNode(Node node) {
        return false;
    }
}

