/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import com.github.benmanes.caffeine.cache.Cache;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.TypeWithAcceptedType;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import io.ballerina.runtime.internal.values.DecimalValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ShapeAnalyzer {
    private static final Cache<InherentShapeTestKeys, Boolean> inherentShapeTestCache = CacheFactory.createCache();

    private ShapeAnalyzer() {
    }

    public static SemType acceptedTypeOf(Context cx, Type typeDesc) {
        if (typeDesc instanceof TypeWithAcceptedType) {
            TypeWithAcceptedType typeWithAcceptedType = (TypeWithAcceptedType)((Object)typeDesc);
            return typeWithAcceptedType.acceptedTypeOf(cx);
        }
        return SemType.tryInto(cx, typeDesc);
    }

    public static Optional<SemType> shapeOf(Context cx, Object object) {
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DecimalValue.class, Double.class, Number.class, Boolean.class, BString.class, BValue.class}, (Object)object2, n)) {
            case -1: {
                return Optional.of(Builder.getNilType());
            }
            case 0: {
                DecimalValue decimalValue = (DecimalValue)object2;
                return Optional.of(Builder.getDecimalConst(decimalValue.value()));
            }
            case 1: {
                Double doubleValue = (Double)object2;
                return Optional.of(Builder.getFloatConst(doubleValue));
            }
            case 2: {
                long l;
                Number intValue = (Number)object2;
                if (intValue instanceof Byte) {
                    Byte byteValue = (Byte)intValue;
                    l = Byte.toUnsignedLong(byteValue);
                } else {
                    l = intValue.longValue();
                }
                long value = l;
                return Optional.of(Builder.getIntConst(value));
            }
            case 3: {
                Boolean booleanValue = (Boolean)object2;
                return Optional.of(Builder.getBooleanConst(booleanValue));
            }
            case 4: {
                BString stringValue = (BString)object2;
                return Optional.of(Builder.getStringConst(stringValue.getValue()));
            }
            case 5: {
                BValue bValue = (BValue)object2;
                Type type = bValue.getType();
                if (type instanceof TypeWithShape) {
                    TypeWithShape typeWithShape = (TypeWithShape)((Object)type);
                    return typeWithShape.shapeOf(cx, ShapeAnalyzer::shapeOf, object);
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static Optional<SemType> inherentTypeOf(Context cx, Object object) {
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BValue.class, Double.class, Number.class, Boolean.class}, (Object)object2, n)) {
            case 0: {
                BValue bValue = (BValue)object2;
                return bValue.inherentTypeOf(cx);
            }
            case -1: {
                return Optional.of(Builder.getNilType());
            }
            case 1: {
                Double doubleValue = (Double)object2;
                return Optional.of(Builder.getFloatConst(doubleValue));
            }
            case 2: {
                long l;
                Number intValue = (Number)object2;
                if (intValue instanceof Byte) {
                    Byte byteValue = (Byte)intValue;
                    l = Byte.toUnsignedLong(byteValue);
                } else {
                    l = intValue.longValue();
                }
                long value = l;
                return Optional.of(Builder.getIntConst(value));
            }
            case 3: {
                Boolean booleanValue = (Boolean)object2;
                return Optional.of(Builder.getBooleanConst(booleanValue));
            }
        }
        return Optional.empty();
    }

    public static boolean canOptimizeInherentTypeCheck(Context cx, Type sourceType, Type targetType) {
        if (sourceType instanceof CacheableTypeDescriptor) {
            CacheableTypeDescriptor cacheableSource = (CacheableTypeDescriptor)sourceType;
            if (targetType instanceof CacheableTypeDescriptor) {
                CacheableTypeDescriptor cacheableTarget = (CacheableTypeDescriptor)targetType;
                InherentShapeTestKeys key = new InherentShapeTestKeys(cacheableSource.typeId(), cacheableTarget.typeId());
                Boolean result = (Boolean)inherentShapeTestCache.getIfPresent((Object)key);
                if (result == null) {
                    result = ShapeAnalyzer.canOptimizeInherentTypeCheckInner(cx, cacheableSource, cacheableTarget);
                    inherentShapeTestCache.put((Object)key, (Object)result);
                }
                return result;
            }
        }
        return ShapeAnalyzer.canOptimizeInherentTypeCheckInner(cx, sourceType, targetType);
    }

    private static boolean canOptimizeInherentTypeCheckInner(Context cx, Type sourceType, Type targetType) {
        TypeWithShape typeWithShape;
        sourceType = TypeUtils.getReferredType(sourceType);
        targetType = TypeUtils.getReferredType(targetType);
        if (sourceType instanceof TypeWithShape && !(typeWithShape = (TypeWithShape)((Object)sourceType)).couldInherentTypeBeDifferent()) {
            return true;
        }
        if (sourceType instanceof BObjectType) {
            BObjectType sourceObjectType = (BObjectType)sourceType;
            if (targetType instanceof BObjectType) {
                BObjectType targetObjectType = (BObjectType)targetType;
                return ShapeAnalyzer.canOptimizeInherentTypeCheckForObjectTypes(sourceObjectType, targetObjectType);
            }
        }
        return Core.isEmpty(cx, Core.intersect(SemType.tryInto(cx, sourceType), SemType.tryInto(cx, targetType)));
    }

    private static boolean canOptimizeInherentTypeCheckForObjectTypes(BObjectType sourceType, BObjectType targetType) {
        Set<String> sourceFieldNames = sourceType.getFields().keySet();
        for (String each : targetType.getFields().keySet()) {
            if (sourceFieldNames.contains(each)) continue;
            return true;
        }
        Set sourceMethodNames = Arrays.stream(sourceType.getMethods()).map(Type::getName).collect(Collectors.toSet());
        for (MethodType each : targetType.getMethods()) {
            if (sourceMethodNames.contains(each.getName())) continue;
            return true;
        }
        return false;
    }

    record InherentShapeTestKeys(int sourceTypeId, int targetTypeId) {
    }
}

