/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.FutureValue;
import io.ballerina.runtime.internal.values.MapValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class AsyncUtils {
    public static Object handleNonIsolatedStrand(Strand strand, Supplier<?> resultSupplier) {
        boolean runnable = strand.isRunnable();
        if (runnable) {
            strand.yield();
        }
        Object result = resultSupplier.get();
        if (runnable) {
            strand.resume();
        }
        return result;
    }

    public static Object handleWait(Strand strand, FutureValue future) {
        future.strand.checkStrandCancelled();
        if (future.getAndSetWaited()) {
            return ErrorUtils.createWaitOnSameFutureError();
        }
        return AsyncUtils.handleWait(strand, future.completableFuture);
    }

    public static Object handleWait(Strand strand, CompletableFuture<Object> completableFuture) {
        if (strand.isIsolated) {
            return AsyncUtils.getFutureResult(completableFuture);
        }
        return AsyncUtils.handleNonIsolatedStrand(strand, () -> AsyncUtils.getFutureResult(completableFuture));
    }

    public static Object handleWaitAny(Strand strand, List<FutureValue> futures) {
        CompletableFuture[] cFutures = new CompletableFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            FutureValue future = futures.get(i);
            future.strand.checkStrandCancelled();
            if (future.getAndSetWaited()) {
                return ErrorUtils.createWaitOnSameFutureError();
            }
            cFutures[i] = future.completableFuture;
        }
        return AsyncUtils.handleWaitAny(strand, cFutures);
    }

    public static void handleWaitMultiple(Strand strand, Map<String, FutureValue> futureMap, MapValue<BString, Object> target) {
        Collection<FutureValue> futures = futureMap.values();
        ArrayList<CompletableFuture<Object>> cFutures = new ArrayList<CompletableFuture<Object>>();
        ArrayList<String> alreadyWaitedKeys = new ArrayList<String>();
        for (Map.Entry<String, FutureValue> entry : futureMap.entrySet()) {
            FutureValue future = entry.getValue();
            future.strand.checkStrandCancelled();
            if (!future.getAndSetWaited()) {
                cFutures.add(future.completableFuture);
                continue;
            }
            alreadyWaitedKeys.add(entry.getKey());
        }
        if (strand.isIsolated) {
            AsyncUtils.waitForAllFutureResult(cFutures.toArray(new CompletableFuture[0]));
            AsyncUtils.getAllFutureResult(futureMap, alreadyWaitedKeys, target);
        }
        AsyncUtils.handleNonIsolatedStrand(strand, () -> {
            AsyncUtils.waitForAllFutureResult(cFutures.toArray(new CompletableFuture[0]));
            AsyncUtils.getAllFutureResult(futureMap, alreadyWaitedKeys, target);
            return null;
        });
    }

    public static Object handleWaitAny(Strand strand, CompletableFuture<?>[] cFutures) {
        Object result = strand.isIsolated ? AsyncUtils.getAnyFutureResult(cFutures) : AsyncUtils.handleNonIsolatedStrand(strand, () -> AsyncUtils.getAnyFutureResult(cFutures));
        if (cFutures.length > 1 && result instanceof BError) {
            ArrayList nonErrorFutures = new ArrayList();
            for (CompletableFuture<?> completableFuture : cFutures) {
                if (completableFuture.isDone()) {
                    result = AsyncUtils.getFutureResult(completableFuture);
                    if (result instanceof BError) continue;
                    return result;
                }
                nonErrorFutures.add(completableFuture);
            }
            if (!nonErrorFutures.isEmpty()) {
                return AsyncUtils.handleWaitAny(strand, nonErrorFutures.toArray(new CompletableFuture[0]));
            }
        }
        return result;
    }

    public static Object getFutureResult(CompletableFuture<?> completableFuture) throws BError {
        try {
            return completableFuture.get();
        }
        catch (Throwable e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BError) {
                BError bError = (BError)throwable;
                throw bError;
            }
            throw ErrorCreator.createError(e);
        }
    }

    public static Object getAnyFutureResult(CompletableFuture<?>[] cFutures) {
        int fSize = cFutures.length;
        CompletableFuture resultFuture = new CompletableFuture();
        AtomicInteger count = new AtomicInteger();
        for (CompletableFuture<?> f : cFutures) {
            f.whenComplete((result, ex) -> {
                if (ex != null) {
                    resultFuture.completeExceptionally((Throwable)ex);
                    return;
                }
                if (count.incrementAndGet() < fSize && result instanceof BError) {
                    return;
                }
                resultFuture.complete(result);
            });
        }
        CompletableFuture<Object> anyFuture = CompletableFuture.anyOf(resultFuture, CompletableFuture.allOf(cFutures));
        Object r = AsyncUtils.getFutureResult(anyFuture);
        if (r != null) {
            return r;
        }
        return AsyncUtils.getFutureResult(resultFuture);
    }

    private static void getAllFutureResult(Map<String, FutureValue> futureMap, List<String> alreadyWaitedKeys, MapValue<BString, Object> target) {
        for (Map.Entry<String, FutureValue> entry : futureMap.entrySet()) {
            FutureValue future = entry.getValue();
            String key = entry.getKey();
            if (alreadyWaitedKeys.contains(key)) {
                target.put(StringUtils.fromString(key), ErrorUtils.createWaitOnSameFutureError());
                continue;
            }
            target.put(StringUtils.fromString(key), AsyncUtils.getFutureResult(future.completableFuture));
        }
    }

    public static void waitForAllFutureResult(CompletableFuture<?>[] futures) {
        CompletableFuture failure = new CompletableFuture();
        for (CompletableFuture<?> f : futures) {
            f.exceptionally(ex -> {
                failure.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        CompletableFuture<Object> future = CompletableFuture.anyOf(failure, CompletableFuture.allOf(futures));
        AsyncUtils.getFutureResult(future);
    }

    private AsyncUtils() {
    }
}

