/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.FutureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.SimpleTypeCheckFlyweightStore;
import io.ballerina.runtime.internal.types.semtype.FutureUtils;
import java.util.Objects;
import java.util.Set;

public class BFutureType
extends BType
implements FutureType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getFutureType();
    private static final SimpleTypeCheckFlyweightStore FLYWEIGHT_CACHE = new SimpleTypeCheckFlyweightStore();
    private final Type constraint;

    public BFutureType(String typeName, Module pkg) {
        super(typeName, pkg, Object.class, true);
        this.constraint = null;
    }

    public BFutureType(Type constraint) {
        super("future", null, Object.class, false);
        this.constraint = constraint;
        SimpleTypeCheckFlyweightStore.TypeCheckFlyweight flyweight = FLYWEIGHT_CACHE.get(constraint);
        this.typeCheckCache = flyweight.typeCheckCache();
        this.typeId = flyweight.typeId();
    }

    public Type getConstrainedType() {
        return this.constraint;
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 45;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BFutureType)) {
            return false;
        }
        BFutureType other = (BFutureType)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.constraint == other.constraint) {
            return true;
        }
        return Objects.equals(this.constraint, other.constraint);
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public String toString() {
        return "future" + this.getConstraintString();
    }

    private String getConstraintString() {
        return this.constraint != null ? "<" + String.valueOf(this.constraint) + ">" : "";
    }

    @Override
    public SemType createSemType(Context cx) {
        if (this.constraint == null) {
            return Builder.getFutureType();
        }
        return FutureUtils.futureContaining(cx.env, BFutureType.tryInto(cx, this.constraint));
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType constraintType;
        Type type = this.constraint;
        return type instanceof MayBeDependentType && (constraintType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }
}

