/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.values.MapValueImpl;
import java.util.stream.Stream;

public class BJsonType
extends BUnionType
implements JsonType {
    private static final BasicTypeBitSet BASIC_TYPE = BJsonType.createBasicType();
    private static final int TYPE_ID_RW = TypeIdSupplier.getReservedId();
    private static final int TYPE_ID_RO = TypeIdSupplier.getReservedId();
    private static final TypeCheckCache TYPE_CHECK_CACHE_RW = TypeCheckCacheFactory.create();
    private static final TypeCheckCache TYPE_CHECK_CACHE_RO = TypeCheckCacheFactory.create();

    private static BasicTypeBitSet createBasicType() {
        int bitset = Stream.of(Builder.getNilType(), Builder.getBooleanType(), Builder.getIntType(), Builder.getFloatType(), Builder.getDecimalType(), Builder.getStringType(), Builder.getListType(), Builder.getMappingType()).map(BasicTypeBitSet::all).reduce(0, (accum, bits) -> accum | bits);
        return new BasicTypeBitSet(bitset);
    }

    public BJsonType(String typeName, Module pkg, boolean readonly) {
        super(typeName, pkg, readonly, MapValueImpl.class, false);
        if (!readonly) {
            BJsonType immutableJsonType = new BJsonType("json & readonly", pkg, true);
            this.immutableType = new BIntersectionType(pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableJsonType, TypeFlags.asMask(1, 2, 4), true);
            this.typeId = TYPE_ID_RW;
            this.typeCheckCache = TYPE_CHECK_CACHE_RW;
        } else {
            this.typeId = TYPE_ID_RO;
            this.typeCheckCache = TYPE_CHECK_CACHE_RO;
        }
    }

    public BJsonType() {
        super("json", null, false, MapValueImpl.class, false);
        BJsonType immutableJsonType = new BJsonType("json & readonly", this.pkg, true);
        this.immutableType = new BIntersectionType(this.pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableJsonType, TypeFlags.asMask(1, 2, 4), true);
        this.typeId = TYPE_ID_RW;
        this.typeCheckCache = TYPE_CHECK_CACHE_RW;
    }

    public BJsonType(BUnionType unionType, String typeName, boolean readonly) {
        super(unionType, typeName, readonly, false);
        if (!readonly) {
            BJsonType immutableJsonType = new BJsonType(unionType, "json & readonly", true);
            this.immutableType = new BIntersectionType(this.pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableJsonType, TypeFlags.asMask(1, 2, 4), true);
            this.typeId = TYPE_ID_RW;
            this.typeCheckCache = TYPE_CHECK_CACHE_RW;
        } else {
            this.typeId = TYPE_ID_RO;
            this.typeCheckCache = TYPE_CHECK_CACHE_RO;
        }
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return (V)new MapValueImpl(this);
    }

    @Override
    public int getTag() {
        return 15;
    }

    @Override
    public boolean isNilable() {
        return true;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public String toString() {
        if (this.typeName != null) {
            return this.typeName;
        }
        return super.toString();
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }
}

