/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.SelectivelyImmutableReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.TypeWithAcceptedType;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public class BUnionType
extends BType
implements UnionType,
SelectivelyImmutableReferenceType,
TypeWithAcceptedType {
    public boolean isCyclic = false;
    public static final String PIPE = "|";
    private List<Type> memberTypes;
    private List<Type> originalMemberTypes;
    private Boolean nullable;
    private long flags = 0L;
    private int typeFlags;
    private boolean readonly;
    protected IntersectionType immutableType;
    private IntersectionType intersectionType = null;
    private String cachedToString;
    private boolean resolving;
    public boolean resolvingReadonly;
    private Boolean shouldCache = null;
    private static final String INT_CLONEABLE = "__Cloneable";
    private static final String CLONEABLE = "Cloneable";
    private static final Pattern pCloneable = Pattern.compile("__Cloneable");
    private BasicTypeBitSet basicType;

    public BUnionType(List<Type> memberTypes, int typeFlags, boolean readonly, boolean isCyclic) {
        this(memberTypes, memberTypes, typeFlags, isCyclic, readonly ? 32L : 0L);
    }

    private BUnionType(List<Type> memberTypes, List<Type> originalMemberTypes, int typeFlags, boolean isCyclic, long flags) {
        super(null, null, Object.class, true);
        this.typeFlags = typeFlags;
        this.readonly = this.isReadOnlyFlagOn(flags);
        this.flags = flags;
        this.setMemberTypes(memberTypes, originalMemberTypes);
        this.isCyclic = isCyclic;
    }

    public BUnionType(int typeFlags, boolean isCyclic, long flags) {
        super(null, null, Object.class, true);
        this.typeFlags = typeFlags;
        this.readonly = this.isReadOnlyFlagOn(flags);
        this.memberTypes = new ArrayList<Type>(0);
        this.isCyclic = isCyclic;
        this.flags = flags;
    }

    public BUnionType(List<Type> memberTypes) {
        this(memberTypes, false);
    }

    public BUnionType(String typeName, Module pkg, List<Type> memberTypes, boolean readonly) {
        super(typeName, pkg, Object.class, true);
        this.readonly = readonly;
        this.setMemberTypes(memberTypes);
    }

    public BUnionType(List<Type> memberTypes, boolean readonly) {
        this(memberTypes, 0, readonly, false);
    }

    public BUnionType(List<Type> memberTypes, boolean readonly, boolean isCyclic) {
        super(null, null, Object.class, true);
        this.typeFlags = 0;
        this.readonly = readonly;
        this.setMemberTypes(memberTypes);
        this.isCyclic = isCyclic;
    }

    public BUnionType(Type[] memberTypes, Type[] originalMemberTypes, int typeFlags) {
        this(memberTypes, originalMemberTypes, typeFlags, false, 0L);
    }

    public BUnionType(Type[] memberTypes, Type[] originalMemberTypes, int typeFlags, boolean isCyclic, long flags) {
        this(Arrays.asList(memberTypes), Arrays.asList(originalMemberTypes), typeFlags, isCyclic, flags);
    }

    public BUnionType(List<Type> memberTypes, String name, Module pkg, int typeFlags, boolean isCyclic, long flags) {
        super(name, pkg, Object.class, true);
        this.typeFlags = typeFlags;
        this.readonly = this.isReadOnlyFlagOn(flags);
        this.memberTypes = memberTypes;
        this.isCyclic = isCyclic;
        this.flags = flags;
    }

    public BUnionType(String name, Module pkg, int typeFlags, boolean isCyclic, long flags) {
        this(new ArrayList<Type>(0), name, pkg, typeFlags, isCyclic, flags);
    }

    protected BUnionType(String typeName, Module pkg, boolean readonly, Class<? extends Object> valueClass, boolean initializeCache) {
        super(typeName, pkg, valueClass, initializeCache);
        this.readonly = readonly;
    }

    protected BUnionType(BUnionType unionType, String typeName, boolean readonly, boolean initializeCache) {
        super(typeName, unionType.pkg, unionType.valueClass, initializeCache);
        this.typeFlags = unionType.typeFlags;
        this.memberTypes = new ArrayList<Type>(unionType.memberTypes.size());
        this.originalMemberTypes = new ArrayList<Type>(unionType.memberTypes.size());
        this.mergeUnionType(unionType);
        this.readonly = readonly;
    }

    public BUnionType(Type[] memberTypes, Type[] originalMemberTypes, String name, Module pkg, int typeFlags, boolean isCyclic, long flags) {
        super(name, pkg, Object.class, true);
        this.typeFlags = typeFlags;
        this.readonly = this.isReadOnlyFlagOn(flags);
        this.isCyclic = isCyclic;
        this.flags = flags;
        this.setMemberTypes(Arrays.asList(memberTypes), Arrays.asList(originalMemberTypes));
        this.typeName = name;
    }

    public void setMemberTypes(Type[] members) {
        if (members == null) {
            return;
        }
        this.memberTypes = this.readonly ? this.getReadOnlyTypes(members) : Arrays.asList(members);
        this.setFlagsBasedOnMembers();
        this.resetSemType();
    }

    public void setOriginalMemberTypes(Type[] originalMemberTypes) {
        this.originalMemberTypes = Arrays.asList(originalMemberTypes);
    }

    private void setOriginalMemberTypes(List<Type> originalMemberTypes) {
        this.originalMemberTypes = originalMemberTypes;
    }

    private void setMemberTypes(List<Type> members) {
        this.setMemberTypes(members, members);
    }

    private void setMemberTypes(List<Type> members, List<Type> originalMembers) {
        if (this.memberTypes != null) {
            this.resetSemType();
        }
        if (members == null) {
            return;
        }
        if (members.isEmpty()) {
            this.memberTypes = members;
            return;
        }
        this.resolvingReadonly = true;
        this.memberTypes = this.readonly ? this.getReadOnlyTypes(members, new HashSet<Type>(members.size())) : members;
        this.resolvingReadonly = false;
        this.setFlagsBasedOnMembers();
        this.setOriginalMemberTypes(originalMembers);
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    @Override
    public boolean isNilable() {
        if (this.memberTypes == null || this.memberTypes.isEmpty()) {
            return true;
        }
        if (this.resolving) {
            return false;
        }
        if (this.nullable == null) {
            this.nullable = this.checkNillable(this.memberTypes);
        }
        return this.nullable;
    }

    private boolean checkNillable(List<Type> memberTypes) {
        this.resolving = true;
        for (Type member : memberTypes) {
            if (!member.isNilable()) continue;
            this.resolving = false;
            return true;
        }
        this.resolving = false;
        return false;
    }

    private void addMember(Type type) {
        this.resetSemType();
        this.memberTypes.add(type);
        this.setFlagsBasedOnMembers();
        this.originalMemberTypes.add(type);
    }

    public void addMembers(Type ... types) {
        this.resetSemType();
        this.memberTypes.addAll(Arrays.asList(types));
        this.setFlagsBasedOnMembers();
        this.originalMemberTypes.addAll(Arrays.asList(types));
    }

    private void setFlagsBasedOnMembers() {
        if (this.resolving) {
            return;
        }
        this.resolving = true;
        this.resolvingReadonly = true;
        boolean nilable = false;
        boolean isAnydata = true;
        boolean isPureType = true;
        boolean readonly = true;
        for (Type memberType : this.memberTypes) {
            nilable |= memberType.isNilable();
            isAnydata &= memberType.isAnydata();
            isPureType &= memberType.isPureType();
            readonly &= memberType.isReadOnly();
        }
        this.resolvingReadonly = false;
        this.resolving = false;
        if (nilable) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 1);
        }
        if (isAnydata) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 2);
        }
        if (isPureType) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 4);
        }
        this.readonly = readonly;
    }

    @Override
    public List<Type> getMemberTypes() {
        return this.memberTypes;
    }

    @Override
    public List<Type> getOriginalMemberTypes() {
        return this.originalMemberTypes;
    }

    public boolean isNullable() {
        return this.isNilable();
    }

    private List<Type> getReadOnlyTypes(List<Type> memberTypes, Set<Type> unresolvedTypes) {
        ArrayList<Type> readOnlyTypes = new ArrayList<Type>(memberTypes.size());
        for (Type type : memberTypes) {
            readOnlyTypes.add(ReadOnlyUtils.getReadOnlyType(type, unresolvedTypes));
        }
        return readOnlyTypes;
    }

    private List<Type> getReadOnlyTypes(Type[] memberTypes) {
        ArrayList<Type> readOnlyTypes = new ArrayList<Type>(memberTypes.length);
        for (Type type : memberTypes) {
            readOnlyTypes.add(ReadOnlyUtils.getReadOnlyType(type));
        }
        return readOnlyTypes;
    }

    @Override
    public <V> V getZeroValue() {
        if (this.isNilable() || this.memberTypes.stream().anyMatch(Type::isNilable)) {
            return null;
        }
        Type firstMemberType = TypeUtils.getImpliedType(this.memberTypes.get(0));
        if (firstMemberType.getTag() == 46) {
            return TypeChecker.getType(((BFiniteType)firstMemberType).getValueSpace().iterator().next()).getZeroValue();
        }
        return firstMemberType.getZeroValue();
    }

    @Override
    public <V> V getEmptyValue() {
        if (this.isNilable() || this.memberTypes.stream().anyMatch(Type::isNilable)) {
            return null;
        }
        Type firstMemberType = TypeUtils.getImpliedType(this.memberTypes.get(0));
        if (firstMemberType.getTag() == 46) {
            return TypeChecker.getType(((BFiniteType)firstMemberType).getValueSpace().iterator().next()).getEmptyValue();
        }
        return firstMemberType.getEmptyValue();
    }

    @Override
    public int getTag() {
        return 33;
    }

    @Override
    public String toString() {
        if (this.resolving) {
            if (this.typeName != null) {
                if (pCloneable.matcher(this.typeName).matches()) {
                    return this.getQualifiedName(CLONEABLE);
                }
                return this.getQualifiedName(this.typeName);
            }
            return "...";
        }
        if (this.typeName != null && !this.typeName.isEmpty()) {
            return this.getQualifiedName(this.typeName);
        }
        this.resolving = true;
        this.computeStringRepresentation();
        this.resolving = false;
        return this.cachedToString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BUnionType)) {
            return false;
        }
        BUnionType that = (BUnionType)o;
        if (this.isCyclic || that.isCyclic) {
            if (this.isCyclic != that.isCyclic) {
                return false;
            }
            return super.equals(that);
        }
        if (this.memberTypes.size() != that.memberTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.memberTypes.size(); ++i) {
            if (this.memberTypes.get(i).equals(that.memberTypes.get(i))) continue;
            return false;
        }
        return this.readonly == that.readonly;
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public long getFlags() {
        return this.flags;
    }

    @Override
    public boolean isReadOnly() {
        if (this.resolvingReadonly) {
            return true;
        }
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        if (this.basicType == null) {
            this.basicType = this.memberTypes.stream().map(Type::getBasicType).reduce(Builder.getNeverType(), BasicTypeBitSet::union);
        }
        return this.basicType;
    }

    @Override
    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void mergeUnionType(BUnionType unionType) {
        if (!unionType.isCyclic) {
            this.addMembers(unionType.getMemberTypes().toArray(new Type[0]));
            return;
        }
        this.isCyclic = true;
        for (Type member : unionType.getMemberTypes()) {
            if (member instanceof BArrayType) {
                BArrayType arrayType = (BArrayType)member;
                if (TypeUtils.getImpliedType(arrayType.getElementType()) == unionType) {
                    BArrayType newArrayType = new BArrayType((Type)this, this.readonly);
                    this.addMember(newArrayType);
                    continue;
                }
            } else if (member instanceof MapType) {
                MapType mapType = (MapType)member;
                if (mapType.getConstrainedType() == unionType) {
                    BMapType newMapType = new BMapType(this, this.readonly);
                    this.addMember(newMapType);
                    continue;
                }
            } else if (member instanceof BTableType) {
                MapType mapType;
                Type newTableType;
                BTableType tableType = (BTableType)member;
                if (tableType.getConstrainedType() == unionType) {
                    newTableType = new BTableType(this, tableType.isReadOnly());
                    this.addMember(newTableType);
                    continue;
                }
                newTableType = tableType.getConstrainedType();
                if (newTableType instanceof MapType && (mapType = (MapType)newTableType).getConstrainedType() == unionType) {
                    BMapType newMapType = new BMapType(this);
                    BTableType newTableType2 = new BTableType(newMapType, tableType.getConstrainedType().isReadOnly());
                    this.addMember(newTableType2);
                    continue;
                }
            }
            this.addMember(member);
        }
        this.setFlagsBasedOnMembers();
    }

    public void computeStringRepresentation() {
        if (this.cachedToString != null) {
            return;
        }
        LinkedHashSet<Type> uniqueTypes = new LinkedHashSet<Type>();
        for (Type type : this.originalMemberTypes) {
            if (type.getTag() != 33) {
                uniqueTypes.add(type);
                continue;
            }
            BUnionType unionMemType = (BUnionType)type;
            String typeName = unionMemType.typeName;
            if (typeName != null && !typeName.isEmpty()) {
                uniqueTypes.add(type);
                continue;
            }
            uniqueTypes.addAll(unionMemType.originalMemberTypes);
        }
        StringJoiner joiner = new StringJoiner(PIPE);
        boolean hasNilableMember = false;
        long numberOfNotNilTypes = 0L;
        for (Type type : uniqueTypes) {
            int tag = type.getTag();
            if (tag == 14) continue;
            String memToString = type.toString();
            if (tag == 33 && memToString.startsWith("(") && memToString.endsWith(")")) {
                joiner.add(memToString.substring(1, memToString.length() - 1));
            } else {
                joiner.add(memToString);
            }
            ++numberOfNotNilTypes;
            if (hasNilableMember || !type.isNilable()) continue;
            hasNilableMember = true;
        }
        Object typeStr = numberOfNotNilTypes > 1L ? "(" + joiner.toString() + ")" : joiner.toString();
        boolean hasNilType = (long)uniqueTypes.size() > numberOfNotNilTypes;
        this.cachedToString = hasNilType && !hasNilableMember ? (String)typeStr + "?" : typeStr;
    }

    private String getQualifiedName(String name) {
        return this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? name : this.pkg.toString() + ":" + name;
    }

    private boolean isReadOnlyFlagOn(long flags) {
        return SymbolFlags.isFlagOn(flags, 32L);
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public SemType createSemType(Context cx) {
        return this.memberTypes.stream().map(type -> SemType.tryInto(cx, type)).reduce(Builder.getNeverType(), Core::union);
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        return this.memberTypes.stream().filter(each -> each instanceof MayBeDependentType).anyMatch(type -> ((MayBeDependentType)((Object)type)).isDependentlyTyped(visited));
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        return this.memberTypes.stream().map(each -> ShapeAnalyzer.acceptedTypeOf(cx, each)).reduce(Builder.getNeverType(), Core::union);
    }
}

