/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import com.github.benmanes.caffeine.cache.LoadingCache;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import java.util.Map;

class SimpleTypeCheckFlyweightStore {
    private final LoadingCache<Integer, TypeCheckFlyweight> unnamedTypeCache = CacheFactory.createCache(TypeCheckFlyweight::new);
    private final TypeCheckFlyweight[] reservedLAT = new TypeCheckFlyweight[128];
    private final Map<Integer, TypeCheckFlyweight> namedTypeCache = CacheFactory.createCachingHashMap();

    SimpleTypeCheckFlyweightStore() {
    }

    public TypeCheckFlyweight get(Type constraint) {
        if (constraint instanceof CacheableTypeDescriptor) {
            CacheableTypeDescriptor cacheableTypeDescriptor = (CacheableTypeDescriptor)constraint;
            return this.getInner(cacheableTypeDescriptor.typeId());
        }
        return new TypeCheckFlyweight(TypeIdSupplier.getAnonId(), TypeCheckCacheFactory.create());
    }

    private TypeCheckFlyweight getInner(int typeId) {
        return switch (TypeIdSupplier.kind(typeId)) {
            default -> throw new MatchException(null, null);
            case TypeIdSupplier.IdKind.RESERVED -> this.getReserved(typeId);
            case TypeIdSupplier.IdKind.NAMED -> this.getNamed(typeId);
            case TypeIdSupplier.IdKind.UNNAMED -> this.getUnnamed(typeId);
        };
    }

    private TypeCheckFlyweight getUnnamed(int typeId) {
        return (TypeCheckFlyweight)this.unnamedTypeCache.get((Object)typeId);
    }

    private TypeCheckFlyweight getNamed(int typeId) {
        TypeCheckFlyweight cached = this.namedTypeCache.get(typeId);
        if (cached != null) {
            return cached;
        }
        cached = new TypeCheckFlyweight(typeId);
        this.namedTypeCache.put(typeId, cached);
        return cached;
    }

    private TypeCheckFlyweight getReserved(int typeId) {
        TypeCheckFlyweight o = this.reservedLAT[typeId];
        if (o == null) {
            this.reservedLAT[typeId] = o = new TypeCheckFlyweight(typeId);
        }
        return o;
    }

    public record TypeCheckFlyweight(int typeId, TypeCheckCache typeCheckCache) {
        public TypeCheckFlyweight(Integer constraintId) {
            this(TypeIdSupplier.getAnonId(), TypeCheckCacheFactory.create());
        }
    }
}

