/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddAllOrNothing;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Conjunction;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Pair;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.BIntSubType;
import io.ballerina.runtime.internal.types.semtype.BListSubType;
import io.ballerina.runtime.internal.types.semtype.FixedLengthArray;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public final class BListProj {
    private BListProj() {
    }

    public static SemType listProjInnerVal(Context cx, SemType t, SemType k) {
        if (t.some() == 0) {
            return t == Builder.getListType() ? Builder.getValType() : Builder.getNeverType();
        }
        SubTypeData keyData = Core.intSubtype(k);
        if (Core.isNothingSubtype(keyData)) {
            return Builder.getNeverType();
        }
        return BListProj.listProjBddInnerVal(cx, keyData, (Bdd)Core.getComplexSubtypeData(t, BasicTypeCode.BT_LIST), null, null);
    }

    private static SemType listProjBddInnerVal(Context cx, SubTypeData k, Bdd b, Conjunction pos, Conjunction neg) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll() ? BListProj.listProjPathInnerVal(cx, k, pos, neg) : Builder.getNeverType();
        }
        BddNode bddNode = (BddNode)b;
        return Core.union(BListProj.listProjBddInnerVal(cx, k, bddNode.left(), Conjunction.and(bddNode.atom(), pos), neg), Core.union(BListProj.listProjBddInnerVal(cx, k, bddNode.middle(), pos, neg), BListProj.listProjBddInnerVal(cx, k, bddNode.right(), pos, Conjunction.and(bddNode.atom(), neg))));
    }

    private static SemType listProjPathInnerVal(Context cx, SubTypeData k, Conjunction pos, Conjunction neg) {
        SemType rest;
        FixedLengthArray members;
        if (pos == null) {
            members = FixedLengthArray.empty();
            rest = Builder.getRwCellContaining(cx.env, Core.union(Builder.getValType(), Builder.getUndefType()));
        } else {
            ListAtomicType lt = cx.listAtomType(pos.atom());
            members = lt.members();
            rest = lt.rest();
            Conjunction p = pos.next();
            if (p != null || neg != null) {
                members = members.shallowCopy();
            }
            while (p != null) {
                Atom d = p.atom();
                p = p.next();
                lt = cx.listAtomType(d);
                Pair<FixedLengthArray, SemType> intersected = BListSubType.listIntersectWith(cx.env, members, rest, lt.members(), lt.rest());
                if (intersected == null) {
                    return Builder.getNeverType();
                }
                members = intersected.first();
                rest = intersected.second();
            }
            if (BListSubType.fixedArrayAnyEmpty(cx, members)) {
                return Builder.getNeverType();
            }
            if (!Core.isNever(Core.cellInnerVal(rest)) && Core.isEmpty(cx, rest)) {
                rest = Builder.getRoCellContaining(cx.env, Builder.getNeverType());
            }
        }
        Integer[] indices = BListSubType.listSamples(cx, members, rest, neg);
        Pair<Integer[], Integer[]> projSamples = BListProj.listProjSamples(indices, k);
        indices = projSamples.first();
        Pair<SemType[], Integer> sampleTypes = BListSubType.listSampleTypes(cx, members, rest, indices);
        return BListProj.listProjExcludeInnerVal(cx, projSamples.first(), projSamples.second(), sampleTypes.first(), sampleTypes.second(), neg);
    }

    private static SemType listProjExcludeInnerVal(Context cx, Integer[] indices, Integer[] keyIndices, SemType[] memberTypes, int nRequired, Conjunction neg) {
        SemType p = Builder.getNeverType();
        if (neg == null) {
            int len = memberTypes.length;
            Integer[] integerArray = keyIndices;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int k = integerArray[i];
                if (k >= len) continue;
                p = Core.union(p, Core.cellInnerVal(memberTypes[k]));
            }
        } else {
            SemType[] t;
            ListAtomicType nt = cx.listAtomType(neg.atom());
            if (nRequired > 0 && Core.isNever(BListSubType.listMemberAtInnerVal(nt.members(), nt.rest(), indices[nRequired - 1]))) {
                return BListProj.listProjExcludeInnerVal(cx, indices, keyIndices, memberTypes, nRequired, neg.next());
            }
            int negLen = nt.members().fixedLength();
            if (negLen > 0) {
                int len = memberTypes.length;
                if (len < indices.length && indices[len] < negLen) {
                    return BListProj.listProjExcludeInnerVal(cx, indices, keyIndices, memberTypes, nRequired, neg.next());
                }
                for (int i = nRequired; i < memberTypes.length && indices[i] < negLen; ++i) {
                    t = Arrays.copyOfRange(memberTypes, 0, i);
                    p = Core.union(p, BListProj.listProjExcludeInnerVal(cx, indices, keyIndices, t, nRequired, neg.next()));
                }
            }
            for (int i = 0; i < memberTypes.length; ++i) {
                SemType d = Core.diff(Core.cellInnerVal(memberTypes[i]), BListSubType.listMemberAtInnerVal(nt.members(), nt.rest(), indices[i]));
                if (Core.isEmpty(cx, d)) continue;
                t = (SemType[])memberTypes.clone();
                t[i] = Builder.getRwCellContaining(cx.env, d);
                p = Core.union(p, BListProj.listProjExcludeInnerVal(cx, indices, keyIndices, t, Integer.max(nRequired, i + 1), neg.next()));
            }
        }
        return p;
    }

    private static Pair<Integer[], Integer[]> listProjSamples(Integer[] indices, SubTypeData k) {
        ArrayList<Pair> v = new ArrayList<Pair>();
        Integer[] integerArray = indices;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            v.add(Pair.from(i2, BIntSubType.intSubtypeContains(k, i2)));
        }
        if (k instanceof BIntSubType.IntSubTypeData) {
            BIntSubType.IntSubTypeData intSubtype = (BIntSubType.IntSubTypeData)k;
            for (BIntSubType.Range range : intSubtype.ranges) {
                long max = range.max();
                if (range.max() < 0L) continue;
                v.add(Pair.from((int)max, true));
                int min = Integer.max(0, (int)range.min());
                if ((long)min >= max) continue;
                v.add(Pair.from(min, true));
            }
        }
        v.sort(Comparator.comparingInt(Pair::first));
        ArrayList<Integer> indices1 = new ArrayList<Integer>();
        ArrayList<Integer> keyIndices = new ArrayList<Integer>();
        for (Pair ib : v) {
            if (!indices1.isEmpty() && Objects.equals(ib.first(), indices1.get(indices1.size() - 1))) continue;
            if (((Boolean)ib.second()).booleanValue()) {
                keyIndices.add(indices1.size());
            }
            indices1.add((Integer)ib.first());
        }
        return Pair.from((Integer[])indices1.toArray(Integer[]::new), (Integer[])keyIndices.toArray(Integer[]::new));
    }
}

