/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract sealed class ImmutableSemType
extends SemType
implements CacheableTypeDescriptor
permits BSemTypeWrapper {
    private static final SubType[] EMPTY_SUBTYPE_DATA = new SubType[0];
    private Integer hashCode;
    private final TypeCheckCache typeCheckCache = TypeCheckCacheFactory.create();
    private final int typeId;

    ImmutableSemType(int all, int some, SubType[] subTypeData) {
        super(all, some, subTypeData);
        this.typeId = TypeIdCache.getTypeId(all, some);
    }

    ImmutableSemType(int all) {
        this(all, 0, EMPTY_SUBTYPE_DATA);
    }

    protected ImmutableSemType(SemType semType) {
        this(semType.all(), semType.some(), semType.subTypeData());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableSemType)) {
            return false;
        }
        ImmutableSemType semType = (ImmutableSemType)o;
        return this.all() == semType.all() && this.some() == semType.some() && Objects.deepEquals(this.subTypeData(), semType.subTypeData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Integer result = this.hashCode;
        if (result == null) {
            ImmutableSemType immutableSemType = this;
            synchronized (immutableSemType) {
                result = this.hashCode;
                if (result == null) {
                    this.hashCode = result = Integer.valueOf(this.computeHashCode());
                }
            }
        }
        return result;
    }

    private int computeHashCode() {
        return Objects.hash(this.all(), this.some(), Arrays.hashCode(this.subTypeData()));
    }

    @Override
    protected void setAll(int all) {
        throw new UnsupportedOperationException("Immutable semtypes cannot be modified");
    }

    @Override
    protected void setSome(int some, SubType[] subTypeData) {
        throw new UnsupportedOperationException("Immutable semtypes cannot be modified");
    }

    @Override
    public Boolean cachedTypeCheckResult(Context cx, CacheableTypeDescriptor other) {
        return this.typeCheckCache.cachedTypeCheckResult(other);
    }

    @Override
    public void cacheTypeCheckResult(CacheableTypeDescriptor other, boolean result) {
        this.typeCheckCache.cacheTypeCheckResult(other, result);
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    private static class TypeIdCache {
        private static final Map<Integer, Integer> TYPE_ID_CACHE = new ConcurrentHashMap<Integer, Integer>();

        private TypeIdCache() {
        }

        public static int getTypeId(int all, int some) {
            if (some != 0) {
                return TypeIdSupplier.getAnonId();
            }
            return TYPE_ID_CACHE.computeIfAbsent(all, k -> TypeIdSupplier.getReservedId());
        }
    }
}

