/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.NonBmpStringValue;
import io.ballerina.runtime.internal.values.StringValue;

public class CharIterator
implements IteratorValue<String> {
    StringValue value;
    long cursor = 0L;
    long length;
    String stringValue;

    CharIterator(StringValue value) {
        this.value = value;
        this.length = value.length();
        this.stringValue = value.getValue();
    }

    @Override
    public String next() {
        long currentIndex = this.cursor++;
        if (this.value.isNonBmp) {
            return this.getNonBmpCharWithSurrogates(currentIndex);
        }
        return String.valueOf(this.stringValue.charAt((int)currentIndex));
    }

    private String getNonBmpCharWithSurrogates(long currentIndex) {
        int offset = (int)currentIndex;
        for (int surrogate : ((NonBmpStringValue)this.value).getSurrogates()) {
            if ((long)surrogate < currentIndex) {
                ++offset;
                continue;
            }
            if ((long)surrogate > currentIndex) break;
            return new String(new char[]{this.stringValue.charAt(offset), this.stringValue.charAt(offset + 1)});
        }
        return String.valueOf(this.stringValue.charAt(offset));
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.length;
    }
}

