/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.regexp.RegExpFactory;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.values.RegExpAtom;
import io.ballerina.runtime.internal.values.RegExpCommonValue;
import io.ballerina.runtime.internal.values.RegExpQuantifier;
import io.ballerina.runtime.internal.values.RegExpTerm;

public class RegExpAtomQuantifier
extends RegExpCommonValue
implements RegExpTerm {
    private Object reAtom;
    private RegExpQuantifier reQuantifier;

    public RegExpAtomQuantifier(Object reAtom, RegExpQuantifier reQuantifier) {
        this.reAtom = this.getValidReAtom(reAtom);
        this.reQuantifier = reQuantifier;
    }

    public Object getReAtom() {
        return this.reAtom;
    }

    public RegExpQuantifier getReQuantifier() {
        return this.reQuantifier;
    }

    public void setReAtom(RegExpAtom reAtom) {
        this.reAtom = reAtom;
    }

    public void setReQuantifier(RegExpQuantifier reQuantifier) {
        this.reQuantifier = reQuantifier;
    }

    private Object getValidReAtom(Object reAtom) {
        if (reAtom instanceof BString) {
            BString bString = (BString)reAtom;
            this.validateInsertion(bString);
        }
        return reAtom;
    }

    private void validateInsertion(BString insertion) {
        RegExpFactory.parseInsertion("(?:" + insertion.getValue() + ")");
    }

    @Override
    public String stringValue(BLink parent) {
        return StringUtils.getStringVal(this.reAtom, parent) + this.reQuantifier.stringValue(parent);
    }
}

