/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.metrics;

import io.ballerina.runtime.observability.metrics.Tag;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MetricId {
    private final String name;
    private final String description;
    private final Set<Tag> tags;
    private final int hashCode;

    public MetricId(String name, String description, List<Tag> tags) {
        this(name, description, (Set<Tag>)(tags != null ? new HashSet<Tag>(tags) : null));
    }

    public MetricId(String name, String description, Set<Tag> tags) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is required.");
        }
        this.name = name;
        this.tags = tags != null ? Collections.unmodifiableSet(tags) : Collections.emptySet();
        this.description = description == null ? "" : description;
        this.hashCode = Objects.hash(name, tags);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricId metricId = (MetricId)o;
        return Objects.equals(this.name, metricId.name) && Objects.equals(this.tags, metricId.tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "MetricId{name='" + this.name + "', description='" + this.description + "', tags=" + String.valueOf(this.tags) + "}";
    }
}

