/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.service;

import io.ballerina.shell.Diagnostic;
import io.ballerina.shell.DiagnosticKind;
import io.ballerina.shell.service.MetaInfo;
import io.ballerina.shell.service.ShellValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BalShellGetResultResponse {
    private ShellValue shellValue = null;
    private final ArrayList<String> errors = new ArrayList();
    private final ArrayList<String> diagnostics = new ArrayList();
    private MetaInfo metaInfo = null;
    private String consoleOut = "";

    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        this.shellValue = new ShellValue(value);
    }

    public void addOutputDiagnostics(Collection<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            DiagnosticKind diagnosticKind = diagnostic.getKind();
            if (diagnosticKind == DiagnosticKind.DEBUG) continue;
            this.diagnostics.add(diagnostic.toString());
        }
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public void setMetaInfo(List<String> definedVars, List<String> moduleDclns) {
        this.metaInfo = new MetaInfo(definedVars, moduleDclns);
    }

    public void setConsoleOut(List<String> consoleOut) {
        this.consoleOut = String.join((CharSequence)"\n", consoleOut);
    }

    public ShellValue getShellValue() {
        return this.shellValue;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public String getConsoleOut() {
        return this.consoleOut;
    }
}

