/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.service;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ConsoleOutCollector
extends OutputStream {
    private final List<String> lines = new ArrayList<String>();
    private final List<Byte> buffer = new ArrayList<Byte>();

    @Override
    public void write(int characterInt) {
        if (characterInt == 10) {
            String buffered = this.collectFromBuffer();
            this.lines.add(buffered);
        } else {
            this.buffer.add((byte)characterInt);
        }
    }

    public List<String> getLines() {
        String buffered = this.collectFromBuffer();
        if (!buffered.isEmpty()) {
            this.lines.add(buffered);
        }
        return this.lines;
    }

    private String collectFromBuffer() {
        Byte[] byteObjects = this.buffer.toArray(new Byte[0]);
        byte[] bytes = new byte[this.buffer.size()];
        int idx = 0;
        for (Byte byt : byteObjects) {
            bytes[idx++] = byt;
        }
        String buffered = new String(bytes, StandardCharsets.UTF_8);
        this.buffer.clear();
        return buffered.trim();
    }
}

