/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ballerina.shell.Evaluator;
import io.ballerina.shell.ExceptionStatus;
import io.ballerina.shell.NotebookReturnValue;
import io.ballerina.shell.ShellCompilation;
import io.ballerina.shell.cli.BShellConfiguration;
import io.ballerina.shell.exceptions.BallerinaShellException;
import io.ballerina.shell.exceptions.InvokerException;
import io.ballerina.shell.exceptions.InvokerPanicException;
import io.ballerina.shell.exceptions.SnippetException;
import io.ballerina.shell.exceptions.TreeParserException;
import io.ballerina.shell.invoker.AvailableVariable;
import io.ballerina.shell.service.BalShellGetResultResponse;
import io.ballerina.shell.service.ConsoleOutCollector;
import io.ballerina.shell.service.ShellFileSourceResponse;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ShellWrapper {
    private final BShellConfiguration configuration = new BShellConfiguration.Builder().build();
    private Evaluator evaluator;
    private File tempFile;
    private static final String TEMP_FILE_PREFIX = "temp-";
    private static final String TEMP_FILE_SUFFIX = ".bal";
    private static final String COMMAND_PREFIX = "/";

    private ShellWrapper() {
        this.initializeEvaluator();
    }

    public static ShellWrapper getInstance() {
        return InstanceHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BalShellGetResultResponse getResult(String source) {
        BalShellGetResultResponse output;
        block20: {
            output = new BalShellGetResultResponse();
            PrintStream originalOut = System.out;
            PrintStream originalErr = System.err;
            ConsoleOutCollector consoleOutCollector = new ConsoleOutCollector();
            PrintStream printStreamCollector = new PrintStream((OutputStream)consoleOutCollector, false, StandardCharsets.UTF_8);
            try (PrintStream printStream = printStreamCollector;){
                System.setOut(printStreamCollector);
                System.setErr(printStreamCollector);
                ShellCompilation shellCompilation = this.evaluator.getCompilation(source);
                if (shellCompilation.getExceptionStatus() == ExceptionStatus.SUCCESS) {
                    Optional compilation = shellCompilation.getPackageCompilation();
                    Optional notebookReturnValue = this.evaluator.getValueAsObject(compilation);
                    if (notebookReturnValue.isPresent() && ((NotebookReturnValue)notebookReturnValue.get()).getExceptionStatus() == ExceptionStatus.SUCCESS) {
                        Object out = ((NotebookReturnValue)notebookReturnValue.get()).getResult();
                        output.setValue(out);
                    } else if (notebookReturnValue.isPresent() && ((NotebookReturnValue)notebookReturnValue.get()).getExceptionStatus() == ExceptionStatus.INVOKER_FAILED) {
                        throw new InvokerException();
                    }
                    break block20;
                }
                if (shellCompilation.getExceptionStatus() == ExceptionStatus.SNIPPET_FAILED) {
                    throw new SnippetException();
                }
                if (shellCompilation.getExceptionStatus() == ExceptionStatus.TREE_PARSER_FAILED) {
                    if (source.startsWith(COMMAND_PREFIX)) {
                        this.evaluator.resetDiagnostics();
                    }
                    throw new TreeParserException();
                }
                throw new InvokerException();
            }
            catch (InvokerPanicException invokerPanicException) {
            }
            catch (Exception error) {
                output.addError(error.getMessage());
            }
            finally {
                output.setConsoleOut(consoleOutCollector.getLines());
                output.addOutputDiagnostics(this.evaluator.diagnostics());
                output.setMetaInfo(this.evaluator.newVariableNames(), this.evaluator.newModuleDeclarations());
                this.evaluator.resetDiagnostics();
                this.evaluator.clearPreviousVariablesAndModuleDclnsNames();
                System.setOut(originalOut);
                System.setErr(originalErr);
            }
        }
        return output;
    }

    public ShellFileSourceResponse getShellFileSource() {
        try {
            String fileContent = Files.readString(Path.of(this.evaluator.getBufferFileUri(), new String[0]), Charset.defaultCharset()).trim();
            File tempFile = this.writeToFile(fileContent);
            return new ShellFileSourceResponse(tempFile, fileContent);
        }
        catch (IOException iOException) {
            return new ShellFileSourceResponse();
        }
    }

    public List<Map<String, String>> getAvailableVariables() {
        ArrayList<Map<String, String>> availableVarsMap = new ArrayList<Map<String, String>>();
        for (AvailableVariable availableVar : this.evaluator.availableVariablesAsObjects()) {
            ObjectMapper oMapper = new ObjectMapper();
            Map varMap = oMapper.convertValue((Object)availableVar, Map.class);
            availableVarsMap.add(varMap);
        }
        return availableVarsMap;
    }

    public boolean deleteDeclarations(String varToDelete) {
        try {
            this.evaluator.delete(List.of(varToDelete));
        }
        catch (BallerinaShellException e) {
            this.evaluator.resetDiagnostics();
            return false;
        }
        return true;
    }

    public boolean restart() {
        this.evaluator.reset();
        this.initializeEvaluator();
        return true;
    }

    private File writeToFile(String source) throws IOException {
        File tempFile = this.getTempBufferFile();
        try (FileWriter fileWriter = new FileWriter(tempFile, Charset.defaultCharset());){
            fileWriter.write(source);
        }
        return tempFile;
    }

    private File getTempBufferFile() throws IOException {
        if (this.tempFile == null) {
            this.tempFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.tempFile.deleteOnExit();
        }
        return this.tempFile;
    }

    private void initializeEvaluator() {
        this.evaluator = this.configuration.getEvaluator();
        try {
            this.evaluator.initialize();
        }
        catch (BallerinaShellException ballerinaShellException) {
        }
        finally {
            this.evaluator.resetDiagnostics();
        }
    }

    private static class InstanceHolder {
        private static final ShellWrapper instance = new ShellWrapper();

        private InstanceHolder() {
        }
    }
}

