/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.compiler;

import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.udp.compiler.Utils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.List;
import java.util.Optional;

public class OnBytesCodeTemplate
implements CodeAction {
    public static final String SERVICE_TEXT = Utils.LS + "\tremote function onBytes(readonly & byte[] data) returns byte[]|udp:Error? {" + Utils.LS + Utils.LS + "\t}" + Utils.LS;

    public List<String> supportedDiagnosticCodes() {
        return List.of("UDP_107");
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext codeActionContext) {
        Diagnostic diagnostic = codeActionContext.diagnostic();
        if (diagnostic.location() == null) {
            return Optional.empty();
        }
        CodeActionArgument locationArg = CodeActionArgument.from((String)"node.location", (Object)diagnostic.location().lineRange());
        return Optional.of(CodeActionInfo.from((String)"Add onBytes remote function", List.of(locationArg)));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext codeActionExecutionContext) {
        return Utils.getDocumentEdits(codeActionExecutionContext, SERVICE_TEXT);
    }

    public String name() {
        return "ADD_ON_BYTES_CODE_SNIPPET";
    }
}

