/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.compiler;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Utils {
    public static final String NODE_LOCATION = "node.location";
    public static final String LS = System.lineSeparator();

    private Utils() {
    }

    public static boolean equals(String actual, String expected) {
        return actual.compareTo(expected) == 0;
    }

    public static NonTerminalNode findNode(SyntaxTree syntaxTree, LineRange lineRange) {
        if (lineRange == null) {
            return null;
        }
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public static List<DocumentEdit> getDocumentEdits(CodeActionExecutionContext codeActionExecutionContext, String serviceText) {
        TextRange resourceTextRange;
        LineRange lineRange = null;
        for (CodeActionArgument argument : codeActionExecutionContext.arguments()) {
            if (!NODE_LOCATION.equals(argument.key())) continue;
            lineRange = (LineRange)argument.valueAs(LineRange.class);
        }
        if (lineRange == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = codeActionExecutionContext.currentDocument().syntaxTree();
        NonTerminalNode node = Utils.findNode(syntaxTree, lineRange);
        if (!(node instanceof ServiceDeclarationNode)) {
            return Collections.emptyList();
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        if (serviceDeclarationNode.members().isEmpty()) {
            resourceTextRange = TextRange.from((int)serviceDeclarationNode.openBraceToken().textRange().endOffset(), (int)(serviceDeclarationNode.closeBraceToken().textRange().startOffset() - serviceDeclarationNode.openBraceToken().textRange().endOffset()));
        } else {
            Node lastMember = serviceDeclarationNode.members().get(serviceDeclarationNode.members().size() - 1);
            resourceTextRange = TextRange.from((int)lastMember.textRange().endOffset(), (int)(serviceDeclarationNode.closeBraceToken().textRange().startOffset() - lastMember.textRange().endOffset()));
        }
        textEdits.add(TextEdit.from((TextRange)resourceTextRange, (String)(serviceDeclarationNode.members().size() > 0 ? serviceText + LS : serviceText)));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        return Collections.singletonList(new DocumentEdit(codeActionExecutionContext.fileUri(), SyntaxTree.from((SyntaxTree)syntaxTree, (TextDocumentChange)change)));
    }
}

