/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import com.sun.jdi.Location;
import com.sun.jdi.request.EventRequestManager;
import io.ballerina.projects.Project;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.ballerinalang.debugadapter.DebugInstruction;
import org.ballerinalang.debugadapter.DebugOutputLogger;
import org.ballerinalang.debugadapter.DebugProjectCache;
import org.ballerinalang.debugadapter.JBallerinaDebugServer;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxyImpl;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;

public class ExecutionContext {
    private IDebugProtocolClient client;
    private final JBallerinaDebugServer adapter;
    private VirtualMachineProxyImpl debuggeeVM;
    private DebugMode debugMode;
    private Project sourceProject;
    private String sourceProjectRoot;
    private final DebugProjectCache projectCache;
    private Process launchedProcess;
    private boolean terminateRequestReceived;
    private boolean supportsRunInTerminalRequest;
    private DebugInstruction prevInstruction;
    private Location prevLocation;

    ExecutionContext(JBallerinaDebugServer adapter) {
        this.adapter = adapter;
        this.projectCache = new DebugProjectCache();
        this.prevInstruction = DebugInstruction.CONTINUE;
        this.prevLocation = null;
    }

    public Optional<Process> getLaunchedProcess() {
        return Optional.ofNullable(this.launchedProcess);
    }

    public void setLaunchedProcess(Process launchedProcess) {
        this.launchedProcess = launchedProcess;
    }

    public IDebugProtocolClient getClient() {
        return this.client;
    }

    public void setClient(IDebugProtocolClient client) {
        this.client = client;
    }

    public JBallerinaDebugServer getAdapter() {
        return this.adapter;
    }

    public VirtualMachineProxyImpl getDebuggeeVM() {
        return this.debuggeeVM;
    }

    public DebugOutputLogger getOutputLogger() {
        return this.getAdapter().getOutputLogger();
    }

    public void setDebuggeeVM(VirtualMachineProxyImpl debuggeeVM) {
        this.debuggeeVM = debuggeeVM;
    }

    public EventRequestManager getEventManager() {
        if (this.debuggeeVM == null) {
            return null;
        }
        return this.debuggeeVM.eventRequestManager();
    }

    public BufferedReader getInputStream() {
        if (this.launchedProcess == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(this.launchedProcess.getInputStream(), StandardCharsets.UTF_8));
    }

    public BufferedReader getErrorStream() {
        if (this.launchedProcess == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(this.launchedProcess.getErrorStream(), StandardCharsets.UTF_8));
    }

    public DebugInstruction getPrevInstruction() {
        return this.prevInstruction;
    }

    public void setPrevInstruction(DebugInstruction prevInstruction) {
        this.prevInstruction = prevInstruction;
    }

    public Optional<Location> getPrevLocation() {
        return Optional.ofNullable(this.prevLocation);
    }

    public void setPrevLocation(Location prevLocation) {
        this.prevLocation = prevLocation;
    }

    public DebugMode getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(DebugMode debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isTerminateRequestReceived() {
        return this.terminateRequestReceived;
    }

    public void setTerminateRequestReceived(boolean terminationRequestReceived) {
        this.terminateRequestReceived = terminationRequestReceived;
    }

    public Project getSourceProject() {
        return this.sourceProject;
    }

    public void setSourceProject(Project sourceProject) {
        this.sourceProject = sourceProject;
        this.setSourceProjectRoot(sourceProject.sourceRoot().toAbsolutePath().toString());
    }

    public DebugProjectCache getProjectCache() {
        return this.projectCache;
    }

    public String getSourceProjectRoot() {
        return this.sourceProjectRoot;
    }

    public void setSourceProjectRoot(String sourceProjectRoot) {
        this.sourceProjectRoot = sourceProjectRoot;
    }

    public void setSupportsRunInTerminalRequest(boolean supportsRunInTerminalRequest) {
        this.supportsRunInTerminalRequest = supportsRunInTerminalRequest;
    }

    public boolean getSupportsRunInTerminalRequest() {
        return this.supportsRunInTerminalRequest;
    }

    public void reset() {
        this.projectCache.clear();
        this.debugMode = null;
        this.debuggeeVM = null;
        this.prevLocation = null;
        this.sourceProject = null;
        this.launchedProcess = null;
        this.sourceProjectRoot = null;
        this.terminateRequestReceived = false;
        this.supportsRunInTerminalRequest = false;
        this.prevInstruction = DebugInstruction.CONTINUE;
    }

    public static enum DebugMode {
        LAUNCH,
        ATTACH;

    }
}

