/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.completion.util.CommonUtil;
import org.eclipse.lsp4j.debug.CompletionItem;

public final class FunctionCompletionItemBuilder {
    private static final String PARENTHESIS = "()";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS = ")";

    private FunctionCompletionItemBuilder() {
    }

    public static CompletionItem build(FunctionSymbol functionSymbol, CompletionContext context) {
        CompletionItem item = new CompletionItem();
        if (functionSymbol != null && functionSymbol.getName().isPresent()) {
            String funcName = (String)functionSymbol.getName().get();
            Pair<String, String> functionSignature = FunctionCompletionItemBuilder.getFunctionInvocationSignature(functionSymbol, funcName, context);
            item.setText((String)functionSignature.getLeft());
            item.setLabel((String)functionSignature.getRight());
        }
        return item;
    }

    private static Pair<String, String> getFunctionInvocationSignature(FunctionSymbol functionSymbol, String functionName, CompletionContext context) {
        if (functionSymbol == null) {
            return ImmutablePair.of((Object)(functionName + PARENTHESIS), (Object)(functionName + PARENTHESIS));
        }
        StringBuilder signature = new StringBuilder(functionName + OPEN_PARENTHESIS);
        StringBuilder insertText = new StringBuilder(functionName + OPEN_PARENTHESIS);
        List<String> funcArguments = FunctionCompletionItemBuilder.getFuncArguments(functionSymbol, context);
        if (!funcArguments.isEmpty()) {
            signature.append(String.join((CharSequence)", ", funcArguments));
        }
        signature.append(CLOSE_PARENTHESIS);
        insertText.append(CLOSE_PARENTHESIS);
        return new ImmutablePair((Object)insertText.toString(), (Object)signature.toString());
    }

    private static List<String> getFuncArguments(FunctionSymbol symbol, CompletionContext context) {
        ArrayList<Object> args = new ArrayList<Object>();
        boolean skipFirstParam = FunctionCompletionItemBuilder.skipFirstParam(context, symbol);
        FunctionTypeSymbol functionTypeDesc = symbol.typeDescriptor();
        Optional restParam = functionTypeDesc.restParam();
        ArrayList parameterDefs = new ArrayList();
        if (functionTypeDesc.params().isPresent()) {
            parameterDefs.addAll((Collection)functionTypeDesc.params().get());
        }
        for (int i = 0; i < parameterDefs.size(); ++i) {
            if (i == 0 && skipFirstParam) continue;
            ParameterSymbol param2 = (ParameterSymbol)parameterDefs.get(i);
            if (param2.typeDescriptor().typeKind() == TypeDescKind.COMPILATION_ERROR) {
                args.add("");
                continue;
            }
            args.add(CommonUtil.getModifiedTypeName(context, param2.typeDescriptor()) + (String)(param2.getName().isEmpty() ? "" : " " + (String)param2.getName().get()));
        }
        restParam.ifPresent(param -> {
            ArrayTypeSymbol typeSymbol = (ArrayTypeSymbol)param.typeDescriptor();
            args.add(CommonUtil.getModifiedTypeName(context, typeSymbol.memberTypeDescriptor()) + (String)(param.getName().isEmpty() ? "" : "... " + (String)param.getName().get()));
        });
        return !args.isEmpty() ? args : new ArrayList<Object>();
    }

    private static boolean skipFirstParam(CompletionContext context, FunctionSymbol functionSymbol) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        return CommonUtil.isLangLib(((ModuleSymbol)functionSymbol.getModule().get()).id()) && nodeAtCursor.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE;
    }
}

