/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.context;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.AsyncSendActionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.completion.resolver.ContextTypeResolver;
import org.ballerinalang.debugadapter.completion.util.CommonUtil;
import org.ballerinalang.debugadapter.completion.util.CompletionUtil;
import org.ballerinalang.debugadapter.completion.util.SymbolUtil;
import org.eclipse.lsp4j.debug.CompletionItem;

public class AsyncSendActionNodeContext {
    public List<CompletionItem> getCompletions(CompletionContext context, AsyncSendActionNode node) {
        return this.getFilteredItems(context, node.expression());
    }

    private List<CompletionItem> getFilteredItems(CompletionContext context, ExpressionNode expressionNode) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        List<Symbol> visibleSymbols = context.visibleSymbols(context.getSuspendedContext().getLineNumber() - 1, 0);
        ContextTypeResolver resolver = new ContextTypeResolver(context);
        Optional expressionType = (Optional)expressionNode.apply((NodeTransformer)resolver);
        if (expressionType.isPresent() && SymbolUtil.isClient((Symbol)expressionType.get())) {
            List<MethodSymbol> clientActions = CommonUtil.getClientActions((Symbol)expressionType.get());
            completionItems.addAll(CompletionUtil.getCompletionItemList(clientActions, context));
        } else {
            List<Symbol> filteredWorkers = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.WORKER).toList();
            completionItems.addAll(CompletionUtil.getCompletionItemList(filteredWorkers, context));
        }
        return completionItems;
    }
}

