/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.tools.text.LinePosition;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;

public class CompletionContext {
    private final SuspendedContext suspendedContext;
    private int cursorPosInTree = -1;
    private NonTerminalNode nodeAtCursor;

    public CompletionContext(SuspendedContext suspendedContext) {
        this.suspendedContext = suspendedContext;
    }

    public List<Symbol> visibleSymbols(int line, int offset) {
        SemanticModel semanticContext = this.suspendedContext.getDebugCompiler().getSemanticInfo();
        return semanticContext.visibleSymbols(this.suspendedContext.getDocument(), LinePosition.from((int)line, (int)offset));
    }

    public Optional<SemanticModel> currentSemanticModel() {
        return Optional.ofNullable(this.suspendedContext.getDebugCompiler().getSemanticInfo());
    }

    public SuspendedContext getSuspendedContext() {
        return this.suspendedContext;
    }

    public int getCursorPositionInTree() {
        return this.cursorPosInTree;
    }

    public void setCursorPositionInTree(int cursorPosInTree) {
        this.cursorPosInTree = cursorPosInTree;
    }

    public NonTerminalNode getNodeAtCursor() {
        return this.nodeAtCursor;
    }

    public void setNodeAtCursor(NonTerminalNode nodeAtCursor) {
        this.nodeAtCursor = nodeAtCursor;
    }
}

