/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.resolver;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingMatchPatternNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.completion.resolver.FieldAccessCompletionResolver;
import org.ballerinalang.debugadapter.completion.util.CommonUtil;
import org.ballerinalang.debugadapter.completion.util.QNameReferenceUtil;
import org.ballerinalang.debugadapter.completion.util.SymbolUtil;

public class ContextTypeResolver
extends NodeTransformer<Optional<TypeSymbol>> {
    private final CompletionContext context;
    private final List<Node> visitedNodes = new ArrayList<Node>();

    public ContextTypeResolver(CompletionContext context) {
        this.context = context;
    }

    public Optional<TypeSymbol> transform(ListenerDeclarationNode node) {
        Optional typeDesc = node.typeDescriptor();
        if (typeDesc.isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((TypeDescriptorNode)typeDesc.get()).apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(SimpleNameReferenceNode node) {
        Optional<Symbol> symbol = this.getSymbolByName(node.name().text());
        if (symbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor(symbol.get());
    }

    public Optional<TypeSymbol> transform(SpecificFieldNode node) {
        Optional parentType = (Optional)node.parent().apply((NodeTransformer)new ContextTypeResolver(this.context));
        if (parentType.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol parentRawType = CommonUtil.getRawType((TypeSymbol)parentType.get());
        if (parentRawType.typeKind() == TypeDescKind.MAP) {
            TypeSymbol rawContextType = this.getRawContextType((TypeSymbol)parentType.get());
            return Optional.of(rawContextType);
        }
        if (parentRawType.typeKind() != TypeDescKind.RECORD || node.fieldName().kind() != SyntaxKind.STRING_LITERAL && node.fieldName().kind() != SyntaxKind.IDENTIFIER_TOKEN) {
            return Optional.empty();
        }
        if (node.fieldName().kind() == SyntaxKind.STRING_LITERAL) {
            return Optional.of(parentRawType);
        }
        RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)parentRawType;
        String fieldName = ((IdentifierToken)node.fieldName()).text();
        Optional<TypeSymbol> typeOfField = recordTypeSymbol.fieldDescriptors().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(fieldName)).findFirst().map(entry -> ((RecordFieldSymbol)entry.getValue()).typeDescriptor());
        return typeOfField.isEmpty() ? Optional.empty() : Optional.of(typeOfField.get());
    }

    public Optional<TypeSymbol> transform(AssignmentStatementNode node) {
        return this.visit(node.varRef());
    }

    public Optional<TypeSymbol> transform(QualifiedNameReferenceNode node) {
        Predicate<Symbol> predicate = symbol -> symbol.getName().isPresent() && (symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS) && ((String)symbol.getName().get()).equals(node.identifier().text());
        List<Symbol> moduleContent = QNameReferenceUtil.getModuleContent(this.context, node, predicate);
        if (moduleContent.size() != 1) {
            return Optional.empty();
        }
        Symbol symbol2 = moduleContent.get(0);
        if (symbol2.kind() == SymbolKind.CLASS) {
            ClassSymbol classSymbol = (ClassSymbol)symbol2;
            return Optional.of(classSymbol);
        }
        TypeSymbol typeDescriptor = ((TypeDefinitionSymbol)symbol2).typeDescriptor();
        return Optional.of(typeDescriptor);
    }

    public Optional<TypeSymbol> transform(VariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(LetVariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(ObjectFieldNode node) {
        Optional symbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol(node.typeName()));
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.TYPE) {
            return Optional.empty();
        }
        return Optional.of(this.getRawContextType((TypeSymbol)symbol.get()));
    }

    public Optional<TypeSymbol> transform(ModuleVariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(IndexedExpressionNode node) {
        Optional containerType = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node));
        if (containerType.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getRawContextType((TypeSymbol)containerType.get()));
    }

    public Optional<TypeSymbol> transform(CaptureBindingPatternNode node) {
        Optional<Symbol> variableSymbol = this.getSymbolByName(node.variableName().text());
        Optional typeSymbol = variableSymbol.flatMap(SymbolUtil::getTypeDescriptor);
        if (typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getRawContextType((TypeSymbol)typeSymbol.get()));
    }

    public Optional<TypeSymbol> transform(AnnotationNode node) {
        Optional<Symbol> annotationSymbol;
        Node annotationRef = node.annotReference();
        Predicate<Symbol> predicate = symbol -> symbol.getName().isPresent() && symbol.kind() == SymbolKind.ANNOTATION;
        if (annotationRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)annotationRef;
            Predicate<Symbol> qNamePredicate = predicate.and(symbol -> ((String)symbol.getName().get()).equals(qNameRef.identifier().text()));
            annotationSymbol = this.getTypeFromQNameReference(qNameRef, qNamePredicate);
        } else if (annotationRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            annotationSymbol = this.getSymbolByName(((SimpleNameReferenceNode)annotationRef).name().text(), predicate);
        } else {
            return Optional.empty();
        }
        if (annotationSymbol.isEmpty()) {
            return Optional.empty();
        }
        return ((AnnotationSymbol)annotationSymbol.get()).typeDescriptor();
    }

    public Optional<TypeSymbol> transform(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        Optional<SemanticModel> semanticModel = this.context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return Optional.empty();
        }
        Optional typeRefSymbol = semanticModel.get().typeOf((Node)errorConstructorExpressionNode);
        if (typeRefSymbol.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType((TypeSymbol)typeRefSymbol.get());
        if (typeSymbol.typeKind() != TypeDescKind.ERROR) {
            return Optional.empty();
        }
        return Optional.ofNullable(CommonUtil.getRawType(((ErrorTypeSymbol)typeSymbol).detailTypeDescriptor()));
    }

    public Optional<TypeSymbol> transform(FunctionDefinitionNode node) {
        Optional returnTypeDesc = node.functionSignature().returnTypeDesc();
        if (returnTypeDesc.isEmpty() || this.context.currentSemanticModel().isEmpty()) {
            return Optional.empty();
        }
        Optional functionSymbol = this.context.currentSemanticModel().get().symbol((Node)node);
        if (functionSymbol.isEmpty()) {
            return Optional.empty();
        }
        return ((FunctionSymbol)functionSymbol.get()).typeDescriptor().returnTypeDescriptor();
    }

    public Optional<TypeSymbol> transform(FieldAccessExpressionNode node) {
        FieldAccessCompletionResolver resolver = new FieldAccessCompletionResolver(this.context);
        List<Symbol> visibleEntries = resolver.getVisibleEntries((Node)node.expression());
        NameReferenceNode nameRef = node.fieldName();
        if (nameRef.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        String fieldName = ((SimpleNameReferenceNode)nameRef).name().text();
        Optional<Symbol> filteredSymbol = visibleEntries.stream().filter(symbol -> symbol.getName().isPresent() && ((String)symbol.getName().get()).equals(fieldName)).findFirst();
        if (filteredSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor(filteredSymbol.get());
    }

    public Optional<TypeSymbol> transform(FunctionCallExpressionNode node) {
        Optional<Object> funcSymbol = Optional.empty();
        NameReferenceNode nameRef = node.functionName();
        if (nameRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nameRef;
            Predicate<Symbol> predicate = symbol -> symbol.getName().isPresent() && symbol.kind() == SymbolKind.FUNCTION;
            Predicate<Symbol> qNamePredicate = predicate.and(symbol -> symbol.getName().orElse("").equals(qNameRef.identifier().text()));
            funcSymbol = this.getTypeFromQNameReference(qNameRef, qNamePredicate);
        } else if (nameRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            funcSymbol = this.getSymbolByName(((SimpleNameReferenceNode)nameRef).name().text());
        }
        if (funcSymbol.isEmpty()) {
            return Optional.empty();
        }
        if (!CommonUtil.isInFunctionCallParameterContext(this.context, node).booleanValue() || !(funcSymbol.get() instanceof FunctionSymbol)) {
            return SymbolUtil.getTypeDescriptor((Symbol)funcSymbol.get());
        }
        Optional<ParameterSymbol> paramSymbol = CommonUtil.resolveFunctionParameterSymbol(((FunctionSymbol)funcSymbol.get()).typeDescriptor(), this.context, node);
        if (paramSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor((Symbol)paramSymbol.get());
    }

    public Optional<TypeSymbol> transform(ImplicitNewExpressionNode implicitNewExpressionNode) {
        Optional classSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)implicitNewExpressionNode)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst();
        if (classSymbol.isEmpty()) {
            return Optional.empty();
        }
        if (!CommonUtil.isInNewExpressionParameterContext(this.context, implicitNewExpressionNode).booleanValue() || !(classSymbol.get() instanceof ClassSymbol)) {
            return SymbolUtil.getTypeDescriptor((Symbol)classSymbol.get());
        }
        Optional args = implicitNewExpressionNode.parenthesizedArgList();
        if (args.isEmpty()) {
            return Optional.empty();
        }
        Optional methodSymbol = ((ClassSymbol)classSymbol.get()).initMethod();
        Optional<ParameterSymbol> paramSymbol = CommonUtil.resolveFunctionParameterSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), this.context, implicitNewExpressionNode);
        if (paramSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor((Symbol)paramSymbol.get());
    }

    public Optional<TypeSymbol> transform(ExplicitNewExpressionNode explicitNewExpressionNode) {
        Optional classSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)explicitNewExpressionNode)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst();
        if (classSymbol.isEmpty()) {
            return Optional.empty();
        }
        if (!CommonUtil.isInNewExpressionParameterContext(this.context, explicitNewExpressionNode).booleanValue() || !(classSymbol.get() instanceof ClassSymbol)) {
            return SymbolUtil.getTypeDescriptor((Symbol)classSymbol.get());
        }
        Optional methodSymbol = ((ClassSymbol)classSymbol.get()).initMethod();
        Optional<ParameterSymbol> paramSymbol = CommonUtil.resolveFunctionParameterSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), this.context, explicitNewExpressionNode);
        if (paramSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor((Symbol)paramSymbol.get());
    }

    public Optional<TypeSymbol> transform(MethodCallExpressionNode node) {
        if (node.methodName().kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        SimpleNameReferenceNode methodName = (SimpleNameReferenceNode)node.methodName();
        FieldAccessCompletionResolver resolver = new FieldAccessCompletionResolver(this.context);
        List<Symbol> visibleEntries = resolver.getVisibleEntries((Node)node.expression());
        Optional<Symbol> methodSymbol = visibleEntries.stream().filter(symbol -> symbol.getName().orElse("").equals(methodName.name().text())).findFirst();
        if (methodSymbol.isEmpty() || methodSymbol.get().kind() != SymbolKind.METHOD) {
            return Optional.empty();
        }
        if (!CommonUtil.isInMethodCallParameterContext(this.context, node).booleanValue()) {
            return SymbolUtil.getTypeDescriptor(methodSymbol.get());
        }
        Optional<ParameterSymbol> paramSymbol = CommonUtil.resolveFunctionParameterSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), this.context, node);
        if (paramSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor((Symbol)paramSymbol.get());
    }

    public Optional<TypeSymbol> transform(RemoteMethodCallActionNode node) {
        Optional methodSymbol = this.context.currentSemanticModel().get().symbol((Node)node);
        if (methodSymbol.isEmpty() || ((Symbol)methodSymbol.get()).kind() != SymbolKind.METHOD) {
            return Optional.empty();
        }
        if (!CommonUtil.isInMethodCallParameterContext(this.context, node).booleanValue()) {
            return (Optional)node.parent().apply((NodeTransformer)this);
        }
        Optional<ParameterSymbol> paramSymbol = CommonUtil.resolveFunctionParameterSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), this.context, node);
        if (paramSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor((Symbol)paramSymbol.get());
    }

    public Optional<TypeSymbol> transform(PositionalArgumentNode positionalArgumentNode) {
        switch (positionalArgumentNode.parent().kind()) {
            case FUNCTION_CALL: {
                return this.getPositionalArgumentTypeForFunction(positionalArgumentNode, (NodeList<FunctionArgumentNode>)((FunctionCallExpressionNode)positionalArgumentNode.parent()).arguments(), positionalArgumentNode.parent());
            }
            case METHOD_CALL: {
                return this.getPositionalArgumentTypeForFunction(positionalArgumentNode, (NodeList<FunctionArgumentNode>)((MethodCallExpressionNode)positionalArgumentNode.parent()).arguments(), positionalArgumentNode.parent());
            }
            case PARENTHESIZED_ARG_LIST: {
                ParenthesizedArgList parenthesizedArgList = (ParenthesizedArgList)positionalArgumentNode.parent();
                switch (parenthesizedArgList.parent().kind()) {
                    case IMPLICIT_NEW_EXPRESSION: {
                        ImplicitNewExpressionNode implicitNewExpressionNode = (ImplicitNewExpressionNode)parenthesizedArgList.parent();
                        Optional argList = implicitNewExpressionNode.parenthesizedArgList();
                        if (argList.isEmpty()) {
                            return Optional.empty();
                        }
                        return this.getPositionalArgumentTypeForNewExpr(positionalArgumentNode, (NodeList<FunctionArgumentNode>)((ParenthesizedArgList)argList.get()).arguments(), (NewExpressionNode)implicitNewExpressionNode);
                    }
                    case EXPLICIT_NEW_EXPRESSION: {
                        ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)parenthesizedArgList.parent();
                        return this.getPositionalArgumentTypeForNewExpr(positionalArgumentNode, (NodeList<FunctionArgumentNode>)explicitNewExpressionNode.parenthesizedArgList().arguments(), (NewExpressionNode)explicitNewExpressionNode);
                    }
                }
            }
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(NamedArgumentNode namedArgumentNode) {
        switch (namedArgumentNode.parent().kind()) {
            case FUNCTION_CALL: 
            case METHOD_CALL: {
                NonTerminalNode parentNode = namedArgumentNode.parent();
                Optional parameterSymbols = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)parentNode)).filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD || symbol.kind() == SymbolKind.RESOURCE_METHOD).flatMap(symbol -> ((FunctionSymbol)symbol).typeDescriptor().params());
                if (parameterSymbols.isEmpty()) {
                    return Optional.empty();
                }
                for (ParameterSymbol parameterSymbol : (List)parameterSymbols.get()) {
                    if (!parameterSymbol.getName().stream().anyMatch(name -> name.equals(namedArgumentNode.argumentName().name().text()))) continue;
                    TypeSymbol typeDescriptor = parameterSymbol.typeDescriptor();
                    return Optional.of(typeDescriptor);
                }
                break;
            }
            case ERROR_CONSTRUCTOR: {
                Optional<TypeSymbol> errorDetail = this.visit((Node)namedArgumentNode.parent());
                if (errorDetail.isEmpty() || errorDetail.get().typeKind() != TypeDescKind.RECORD) {
                    return Optional.empty();
                }
                Optional<RecordFieldSymbol> fieldSymbol = ((RecordTypeSymbol)errorDetail.get()).fieldDescriptors().values().stream().filter(recordFieldSymbol -> recordFieldSymbol.getName().isPresent() && namedArgumentNode.argumentName().name().text().trim().equals(recordFieldSymbol.getName().get())).findFirst();
                if (!fieldSymbol.isPresent()) break;
                return Optional.of(fieldSymbol.get().typeDescriptor());
            }
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(ListConstructorExpressionNode node) {
        Optional<TypeSymbol> typeSymbol = this.visit((Node)node.parent());
        if (typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol.get());
        if (rawType.typeKind() != TypeDescKind.ARRAY) {
            return Optional.empty();
        }
        TypeSymbol memberType = ((ArrayTypeSymbol)rawType).memberTypeDescriptor();
        return Optional.of(memberType);
    }

    public Optional<TypeSymbol> transform(DefaultableParameterNode node) {
        Optional symbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)node));
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.PARAMETER) {
            return Optional.empty();
        }
        ParameterSymbol parameterSymbol = (ParameterSymbol)symbol.get();
        TypeSymbol typeDescriptor = parameterSymbol.typeDescriptor();
        return Optional.of(typeDescriptor);
    }

    public Optional<TypeSymbol> transform(ExplicitAnonymousFunctionExpressionNode node) {
        Optional returnTypeDesc = node.functionSignature().returnTypeDesc();
        if (returnTypeDesc.isEmpty() || this.context.currentSemanticModel().isEmpty()) {
            return Optional.empty();
        }
        Optional typeSymbol = this.context.currentSemanticModel().get().symbol(((ReturnTypeDescriptorNode)returnTypeDesc.get()).type());
        if (typeSymbol.isEmpty() || ((Symbol)typeSymbol.get()).kind() != SymbolKind.TYPE) {
            return Optional.empty();
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbol.get();
        return Optional.of(symbol);
    }

    public Optional<TypeSymbol> transform(ImplicitAnonymousFunctionExpressionNode node) {
        Optional<TypeSymbol> typeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node)).or(() -> (Optional)node.parent().apply((NodeTransformer)this));
        if (typeSymbol.isEmpty() || ((TypeSymbol)typeSymbol.get()).typeKind() != TypeDescKind.FUNCTION) {
            return Optional.empty();
        }
        FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)typeSymbol.get();
        if (!node.rightDoubleArrow().isMissing() && this.context.getCursorPositionInTree() >= node.rightDoubleArrow().textRange().endOffset()) {
            return functionTypeSymbol.returnTypeDescriptor();
        }
        return typeSymbol;
    }

    public Optional<TypeSymbol> transform(RecordFieldWithDefaultValueNode node) {
        Optional symbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol(node.typeName()));
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.TYPE) {
            return Optional.empty();
        }
        return Optional.of(this.getRawContextType((TypeSymbol)symbol.get()));
    }

    public Optional<TypeSymbol> transform(MappingConstructorExpressionNode mappingConstructorExpressionNode) {
        return this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)mappingConstructorExpressionNode)).filter(typeSymbol -> typeSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR).or(() -> (Optional)mappingConstructorExpressionNode.parent().apply((NodeTransformer)this));
    }

    public Optional<TypeSymbol> transform(MappingMatchPatternNode mappingMatchPatternNode) {
        return (Optional)mappingMatchPatternNode.parent().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(MatchClauseNode matchClauseNode) {
        return (Optional)matchClauseNode.parent().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(MatchStatementNode matchStatementNode) {
        return this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)matchStatementNode.condition()));
    }

    protected Optional<TypeSymbol> transformSyntaxNode(Node node) {
        return this.visit((Node)node.parent());
    }

    private Optional<Symbol> getTypeFromQNameReference(QualifiedNameReferenceNode node, Predicate<Symbol> predicate) {
        List<Symbol> moduleContent = QNameReferenceUtil.getModuleContent(this.context, node, predicate);
        if (moduleContent.size() != 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(moduleContent.get(0));
    }

    private Optional<TypeSymbol> visit(Node node) {
        if (node == null || this.visitedNodes.contains(node)) {
            return Optional.empty();
        }
        this.visitedNodes.add(node);
        return (Optional)node.apply((NodeTransformer)this);
    }

    private Optional<Symbol> getSymbolByName(String name) {
        return this.context.visibleSymbols(this.context.getSuspendedContext().getLineNumber() - 1, 0).stream().filter(symbol -> symbol.getName().orElse("").equals(name)).findFirst();
    }

    private Optional<Symbol> getSymbolByName(String name, Predicate<Symbol> predicate) {
        Predicate<Symbol> namePredicate = symbol -> symbol.getName().orElse("").equals(name);
        return this.context.visibleSymbols(this.context.getSuspendedContext().getLineNumber() - 1, 0).stream().filter(namePredicate.and(predicate)).findFirst();
    }

    private TypeSymbol getRawContextType(TypeSymbol typeSymbol) {
        TypeSymbol rawType = typeSymbol;
        switch (typeSymbol.typeKind()) {
            case MAP: {
                rawType = ((MapTypeSymbol)rawType).typeParam();
                break;
            }
            case TABLE: {
                rawType = ((TableTypeSymbol)rawType).rowTypeParameter();
                break;
            }
        }
        return rawType;
    }

    private Optional<TypeSymbol> getPositionalArgumentTypeForFunction(PositionalArgumentNode positionalArgNode, NodeList<FunctionArgumentNode> argumentNodes, NonTerminalNode functionOrMethodCallExpr) {
        Optional<FunctionTypeSymbol> optSymbol;
        int argIndex = -1;
        for (int i = 0; i < argumentNodes.size(); ++i) {
            if (!((FunctionArgumentNode)argumentNodes.get(i)).equals(positionalArgNode)) continue;
            argIndex = i;
            break;
        }
        boolean isLangLibFunction = false;
        FunctionTypeSymbol functionTypeSymbol = null;
        if (functionOrMethodCallExpr.kind() == SyntaxKind.METHOD_CALL && (optSymbol = this.findMethodInLangLibMethods((MethodCallExpressionNode)functionOrMethodCallExpr)).isPresent()) {
            functionTypeSymbol = optSymbol.get();
            isLangLibFunction = true;
        }
        if (functionTypeSymbol == null) {
            functionTypeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)functionOrMethodCallExpr)).filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD || symbol.kind() == SymbolKind.RESOURCE_METHOD).map(symbol -> ((FunctionSymbol)symbol).typeDescriptor()).orElse(null);
        }
        if (functionTypeSymbol == null) {
            return Optional.empty();
        }
        Optional parameterSymbols = functionTypeSymbol.params();
        Optional restParam = functionTypeSymbol.restParam();
        if (argIndex == -1 || parameterSymbols.isEmpty()) {
            return Optional.empty();
        }
        if (isLangLibFunction) {
            ++argIndex;
        }
        TypeSymbol typeDescriptor = null;
        if (((List)parameterSymbols.get()).size() > argIndex) {
            ParameterSymbol parameterSymbol = (ParameterSymbol)((List)parameterSymbols.get()).get(argIndex);
            typeDescriptor = parameterSymbol.typeDescriptor();
        } else if (restParam.isPresent() && (typeDescriptor = ((ParameterSymbol)restParam.get()).typeDescriptor()).typeKind() == TypeDescKind.ARRAY) {
            typeDescriptor = ((ArrayTypeSymbol)typeDescriptor).memberTypeDescriptor();
        }
        return Optional.ofNullable(typeDescriptor);
    }

    private Optional<FunctionTypeSymbol> findMethodInLangLibMethods(MethodCallExpressionNode methodCallExpr) {
        if (methodCallExpr.methodName().kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        SimpleNameReferenceNode typeRefNode = (SimpleNameReferenceNode)methodCallExpr.methodName();
        Optional typeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)methodCallExpr.expression()));
        return typeSymbol.flatMap(value -> value.langLibMethods().stream().filter(method -> method.getName().isPresent() && ((String)method.getName().get()).equals(typeRefNode.name().text())).findFirst().map(FunctionSymbol::typeDescriptor));
    }

    private Optional<TypeSymbol> getPositionalArgumentTypeForNewExpr(PositionalArgumentNode positionalArgumentNode, NodeList<FunctionArgumentNode> argumentNodes, NewExpressionNode newExpressionNode) {
        int argIndex = -1;
        for (int i = 0; i < argumentNodes.size(); ++i) {
            if (!((FunctionArgumentNode)argumentNodes.get(i)).equals(positionalArgumentNode)) continue;
            argIndex = i;
            break;
        }
        Optional parameterSymbols = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)newExpressionNode)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).filter(typeSymbol -> typeSymbol instanceof ClassSymbol).flatMap(typeSymbol -> ((ClassSymbol)typeSymbol).initMethod()).flatMap(methodSymbol -> methodSymbol.typeDescriptor().params());
        if (argIndex == -1 || parameterSymbols.isEmpty() || ((List)parameterSymbols.get()).size() <= argIndex) {
            return Optional.empty();
        }
        TypeSymbol typeDescriptor = ((ParameterSymbol)((List)parameterSymbols.get()).get(argIndex)).typeDescriptor();
        return Optional.of(typeDescriptor);
    }
}

