/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import org.ballerinalang.debugadapter.SuspendedContext;

public class DebugExpressionCompiler {
    private final SuspendedContext context;
    private Document document;

    public DebugExpressionCompiler(SuspendedContext context) {
        this.context = context;
    }

    public PackageCompilation getModuleCompilation(String expr) {
        if (this.document == null) {
            this.document = this.context.getDocument();
        }
        if (expr == null || expr.isBlank()) {
            return this.document.module().packageInstance().getCompilation();
        }
        String exprStatement = DebugExpressionCompiler.getExpressionStatement(expr);
        int startOffset = this.document.textDocument().line(this.context.getLineNumber() - 1).endOffset();
        TextEdit[] textEdit = new TextEdit[]{TextEdit.from((TextRange)TextRange.from((int)startOffset, (int)0), (String)exprStatement)};
        String newContent = new String(this.document.textDocument().apply(TextDocumentChange.from((TextEdit[])textEdit)).toCharArray());
        Document newDocument = this.document.modify().withContent(newContent).apply();
        return newDocument.module().packageInstance().getCompilation();
    }

    public SemanticModel getSemanticInfo() {
        if (this.document == null) {
            this.document = this.context.getDocument();
        }
        return this.document.module().packageInstance().getCompilation().getSemanticModel(this.document.module().moduleId());
    }

    private static String getExpressionStatement(String expression) {
        if (!((String)expression).trim().endsWith(SyntaxKind.SEMICOLON_TOKEN.stringValue())) {
            expression = (String)expression + SyntaxKind.SEMICOLON_TOKEN.stringValue();
        }
        return "_ = " + (String)expression;
    }
}

